/***************************************************************************
 *   Copyright (C) 2004 by Nilesh Bansal                                   *
 *   nilesh@iitb.ac.in                                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef FTPMONITOR_H
#define FTPMONITOR_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <qstring.h>
#include <kpanelapplet.h>
#include <kconfig.h>
#include <qtoolbutton.h>
#include <kmainwindow.h>
#include <qlayout.h>
#include <qpushbutton.h>
#include <qpopupmenu.h>
#include <qpixmap.h>
#include <qbitmap.h>
#include <qpainter.h>
#include <qevent.h>

#include "FTPMonitorLoop.h"
#include "FTPConfig.h"


class FTPMonitor : public KPanelApplet
{
    Q_OBJECT

    public:
        FTPMonitor(const QString& configFile, Type t = Normal, int actions = 0,
                QWidget *parent = 0, const char *name = 0);
        ~FTPMonitor();

        virtual int widthForHeight(int height) const;
        virtual int heightForWidth(int width) const;
        virtual void about();
        virtual void help();
        virtual void preferences();

        QPixmap iconConnected, iconIdle; 
        QBitmap bitmapConnected, bitmapIdle;
        void processIcons();		

    protected:
        void resizeEvent(QResizeEvent *);
        void paintEvent(QPaintEvent *);
        void slotClicked();

        protected slots:
            void slotReverse();
        void slotChangeInConn();
        void showPrefs();
        void showAbout();
        void showHelp();
        void showLog();

    private:
        KConfig *ksConfig;
        int number;
        FTPMonitorLoop * monitorLoop;
        QPopupMenu *  popupmenu;
        void mousePressEvent(QMouseEvent*);
        void changeToolTip();
        int popupEnable;
        int notifyPopupTime;
        QVBoxLayout * layout;
        int infoPopupTime;
        int middleClickCommandSet;
        QString middleClickCommand;
};

#endif
