/***************************************************************************
 *   Copyright (C) 2004 by Nilesh Bansal                                   *
 *   nilesh@iitb.ac.in                                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef FTP_MONITOR_LOOP_H
#define FTP_MONITOR_LOOP_H

#include <qobject.h>

#include <sys/types.h>
#include <signal.h>
#include <unistd.h>

#include <qfile.h>
#include <qstring.h>
#include <qstringlist.h>
#include <qtextstream.h>
#include <qdir.h>
#include <qtimer.h>
#include <qmap.h>
#include <qdatetime.h>

#include <klocale.h>
#include <qprocess.h>
#include <qstring.h>
#include <qstringlist.h>
#include <qfile.h> 

class FTPMonitorLoopPrivate{
    public:
        FTPMonitorLoopPrivate();
        ~FTPMonitorLoopPrivate();
        int interval_;
        QTimer * timer_;
};

class FTPMonitorLoop : public QObject
{
    Q_OBJECT
    public:
        FTPMonitorLoop
            (
             int interval,
             QObject * parent = 0,
             char * name = "FTP Monitor Loop"
            );
        ~FTPMonitorLoop();

        void setInterval(int);
        int getInterval();
        void start();
        void stop();
        void execWho();
        QString * ftp_string;
        int no_of_connections;
        int old_no_of_connections;
        QString  path_to_pureftpwho;
        QString  path;
        int setPath(QString);
        void setPathPrivate(QString);
        int ftpdaemon;
        int useSudo;

        protected slots:
            void slotTimeout();
        void readFromStdout();
        void readFromStdoutNcFtpd();
        void readFromStdoutVsFtpd();
        void readFromStdoutPureFtpd();
        void readFromStdoutProFtpd();

    private:
        FTPMonitorLoopPrivate * d;
        QProcess * proc;
        int whoIsRunning; /*Is 1 if some background who process is running*/
        void execWhoPureFtpd();
        void execWhoNcFtpd();
        void execWhoVsFtpd();
        void execWhoProFtpd();

signals:
        void reverse();
        void change_in_conn();
};
#endif
