#include "FTPConfig.h"

#include <qmessagebox.h>
#include <qtoolbutton.h>
#include <qlayout.h>
#include <kiconloader.h>
#include <kglobal.h>
#include <kconfig.h>
#include <kaboutapplication.h>
#include <kaboutdata.h>
#include <klineedit.h>
#include <klocale.h>
#include <kpopupmenu.h>
#include <kmessagebox.h>
#include <qpushbutton.h>
#include <qvbox.h>
#include <qlabel.h> 
#include <qvgroupbox.h>
#include <qframe.h>
#include <qlayout.h>
#include <qcombobox.h>
#include <qwhatsthis.h>

FTPConfig::FTPConfig( KConfig * ksConfig,
        QWidget * parent,
        const char * name )
:  KDialogBase
(Tabbed, i18n("FTP Monitor Configuration" ),
 Ok|Cancel, Ok )
{
    int ftpdaemon = ksConfig->readNumEntry("ftp_daemon",1);
    int updateInterval = ksConfig->readNumEntry("update_interval",1);
    int notifyPopupTime = ksConfig->readNumEntry("notify_popup_time",1000);
    int popupEnable = ksConfig->readNumEntry("popup_enable",1);
    QString path_pureftpwho = ksConfig->readEntry("pure-ftpwhopath", "/usr/bin/pure-ftpwho");
    int middleMouseClickSet = ksConfig->readNumEntry("middle_click_command_set",0); 
    QString middleMouseClick = ksConfig->readEntry("middle_click_command","");
    int infoPopupTime =  ksConfig->readNumEntry("info_popup_time",10000);

    myksConfig = ksConfig;

    KGlobal::iconLoader()->addAppDir("ftpmonitor");
    setIcon( SmallIcon( "ftpmonitor-icon" ) );
    page = addPage( i18n( "&General" ) );
    b = new QVGroupBox(i18n("Notifications"), page);
    bl = new QVBoxLayout(page, 0, spacingHint());	
    //be careful -- bl and b1 look very simmiliar.
    b1 = new QVGroupBox(i18n("Notification Popup"), page);
    bl->addWidget(b1);
    popupEnableBox = new QCheckBox(b1);
    popupEnableBox->setText(i18n("Notifications Enabled"));
    if(popupEnable){
        popupEnableBox->setChecked(true);
    }
    QWhatsThis::add(popupEnableBox, i18n("This will enable/disable notifications which appears when number of connections change."));
    connect(
            popupEnableBox, SIGNAL(clicked()) ,
            this, SLOT(notificationsStateChanged())
           );
    notifyInterval_ = new KIntNumInput(notifyPopupTime, b1);
    notifyInterval_ -> setRange (500, 5000, 100);
    notifyInterval_ -> setSuffix(i18n(" msecs"));
    notifyInterval_ -> setLabel(i18n("Notify Popup Time"), AlignVCenter | AlignLeft);
    QWhatsThis::add(notifyInterval_, i18n("Time for which popup notifications (which appear when number of connections change) should remain alive"));
    bl -> addStretch();

    b3 = new QVGroupBox(i18n("Information Popup"), page);
    bl -> addWidget(b3);
    infoPopupTime_ = new KIntNumInput(infoPopupTime, b3);
    infoPopupTime_ -> setRange (1000, 30000, 1000);
    infoPopupTime_ -> setSuffix(i18n(" msecs"));
    infoPopupTime_ -> setLabel(i18n("Information popup time"), AlignVCenter | AlignLeft);
    QWhatsThis::add(infoPopupTime_, i18n("Time for which popup showing details of all active connections should remain alive"));
    bl -> addStretch(1);

    page = addPage( i18n( "&FTP Daemon" ) );
    b1 = new QVGroupBox(i18n("FTP Daemon"), page);
    bl1 = new QVBoxLayout(page, 0, spacingHint());
    gl = new QVBoxLayout(b1, 0, spacingHint());
    ftpdaemonSelector_ = new KComboBox(false, b1);
    ftpdaemonSelector_ -> insertItem("ncftpd", 0);
    ftpdaemonSelector_ -> insertItem("pure-ftpd", 1);
    ftpdaemonSelector_ -> insertItem("vsftpd", 2);
    ftpdaemonSelector_ -> insertItem("proftpd", 3);
    ftpdaemonSelector_ -> setCurrentItem(ftpdaemon);
    connect(
            ftpdaemonSelector_, SIGNAL(activated(int)),
            this, SLOT(ftpdaemonChanged())
           );
    gl -> addWidget(ftpdaemonSelector_);
    bl1->addWidget(b1);

    bl1->addStretch();
    b2 = new QVGroupBox(i18n("Paths"), page);
    bl1->addWidget(b2);
    useSudo_ = new QCheckBox(b2, "");
    useSudo_->setText(i18n("Use sudo"));
    QWhatsThis::add(useSudo_, i18n("As you may need root privileges to run some commands, do you want to run those commands with sudo or youwant to set them setuid root?"));
    pathLabel = new QLabel(i18n("Path to pure-ftpwho"), b2);
    pathSelector_ = new KURLRequester(path_pureftpwho, b2);
    pathSelector_ ->setMode(KFile::ExistingOnly);
    QWhatsThis::add(pathSelector_ , i18n("Complete path to pure-ftpwho command which is used as backend to find all active ftp connections."));
    bl1->addStretch(1);
    notificationsStateChanged();
    ftpdaemonChanged();

    // page = addPage(i18n("&Look and Feel")) ;
    // b3 = new QVGroupBox(i18n("Select Icon"), page);
    // bl2 = new QVBoxLayout(page, 0, spacingHint());
    // enableTransparency_ = new QCheckBox(b3);
    // enableTransparency_->setText(i18n("Enable transparency"));
    // if (enableTransparency)
    //	enableTransparency_->setChecked(true);
    // else 
    //	enableTransparency_->setChecked(false);
    // bl2->addWidget(b3);	  
    // bl2->addStretch();

    page = addPage(i18n("&Key Mappings")) ;
    b4 = new QVGroupBox(i18n("Mouse middle click"), page);
    bl3 = new QVBoxLayout(page, 0, spacingHint());
    middleMouseClickSet_ = new QCheckBox(b4); 	
    middleMouseClickSet_->setText(i18n("Middle mouse click run following command"));
    if (middleMouseClickSet)
        middleMouseClickSet_->setChecked(true);
    connect(
            middleMouseClickSet_, SIGNAL(toggled(bool)) ,
            this, SLOT(middleMouseClickStatusChanged())
           );
    middleMouseClick_  = new KLineEdit(b4);
    middleMouseClick_->setText(middleMouseClick);	

    middleMouseClickStatusChanged();
    bl3 -> addWidget(b4);
    bl3 -> addStretch();
}


FTPConfig::~FTPConfig()
{
    delete notifyInterval_;
    delete ftpdaemonSelector_;
    delete pathLabel;
    delete pathSelector_;
    delete useSudo_;
    //	delete infoPopupInterval_;
    delete middleMouseClick_;
    delete middleMouseClickSet_;
    delete b2;	
    delete gl;
    delete bl1;
    delete b3;
    delete b1;
    delete bl;
    delete b;
    delete b4;
    delete bl3;
    delete page;
}

    void
FTPConfig::notificationsStateChanged()
{
    notifyInterval_ -> setEnabled(popupEnableBox->isChecked());
    //	notifyInterval_ -> setEnabled(false);
}

    void
FTPConfig::ftpdaemonChanged()
{
    if(ftpdaemonSelector_->currentItem()==0){
        pathLabel->setText(i18n("Path to ncftpd_spy"));
        pathSelector_->setEnabled(true);
        pathSelector_->setURL(myksConfig->readEntry("ncftpd_spypath",
                    "/usr/local/sbin/ncftpd_spy"));
        useSudo_->setChecked(true);
        useSudo_->setEnabled(false);
    }else if(ftpdaemonSelector_->currentItem()==1){
        pathLabel->setText(i18n("Path to pure-ftpwho"));
        pathSelector_->setEnabled(true);
        pathSelector_->setURL(myksConfig->readEntry("pure-ftpwhopath",
                    "/usr/local/sbin/pure-ftpwho"));
        useSudo_->setEnabled(true);
        if (myksConfig->readNumEntry("pureftpd_use_sudo", 0))
            useSudo_->setChecked(true);
        else
            useSudo_->setChecked(false);
    }else if(ftpdaemonSelector_->currentItem()==3){
        pathLabel->setText(i18n("Path to ftpwho"));
        pathSelector_->setEnabled(true);
        pathSelector_->setURL(myksConfig->readEntry("proftpwhopath",
                    "/usr/bin/ftpwho"));
        useSudo_->setChecked(false);
        useSudo_->setEnabled(false);
    }else{
        pathLabel->setText(i18n(""));
        pathSelector_->setEnabled(false);
        pathSelector_->setURL("");
        useSudo_->setChecked(false);
        useSudo_->setEnabled(false);
    }

}

    void 
FTPConfig::middleMouseClickStatusChanged()
{
    if(middleMouseClickSet_->isChecked()){
        middleMouseClick_->setReadOnly(false);
    }else{
        middleMouseClick_->setReadOnly(true);
    }
}
