#!/bin/bash

# This script takes the images rendered with normal colors and the images rendered in green-red
# and outputs the transparent images with transparent shades.
# The script presumes that the normal render and the green-red render are in the hardcoded directories.
# The script works only with ImageMagick 6 and higher, supporting the -fx option.

mkdir -p transparent

rm transparent/*;

rm red.png green.png blue.png alpha.png;

for file in green-red/*.png; do
	FILENAME=$(basename $file);
	convert green-red/$FILENAME  -fx R alpha.png	
	convert normal/$FILENAME  -fx R red.png
	convert normal/$FILENAME  -fx G green.png
	convert normal/$FILENAME  -fx B blue.png	
	convert  red.png green.png blue.png alpha.png -channel RGBA -combine transparent/$FILENAME
done
