var Flashblock = {

    // File mode flags

    MODE_RDONLY   : 0x01,
    MODE_WRONLY   : 0x02,
    MODE_RDWR     : 0x04,
    MODE_CREATE   : 0x08,
    MODE_APPEND   : 0x10,
    MODE_TRUNCATE : 0x20,
    MODE_SYNC     : 0x40,
    MODE_EXCL     : 0x80,

    /// USER STYLESHEET FUNCTIONS

    // Returns a nsIFile for the specified file in the profile chrome directory
    getUserChromeFile : function(fileName) {
        var NSIFILE = Components.interfaces.nsIFile;
        var dirLocator = Components.classes["@mozilla.org/file/directory_service;1"]
                                   .getService(Components.interfaces.nsIProperties);
        var userChromePath = dirLocator.get("UChrm", NSIFILE).path;

        var file = Components.classes["@mozilla.org/file/local;1"]
                             .createInstance(Components.interfaces.nsILocalFile);

        file.initWithPath(userChromePath);
        file.append(fileName);

        return file;
    },

    // Returns the contents of the specified file in the profile chrome directory
    readUserChromeFile : function (fileName) {
        var fileContents = "";
        var file = Flashblock.getUserChromeFile(fileName);

        if(file.exists()) {
            var ioFlags = this.MODE_RDONLY;

            // Get an input stream
            var is = Components.classes["@mozilla.org/network/file-input-stream;1"]
                               .createInstance( Components.interfaces.nsIFileInputStream);
            is.init(file, ioFlags, 0, is.CLOSE_ON_EOF);
            var sis = Components.classes["@mozilla.org/scriptableinputstream;1"]
                                .createInstance( Components.interfaces.nsIScriptableInputStream);
            sis.init(is);

            // Read the file in
            while(sis.available() > 0)
                fileContents += sis.read(sis.available());

            // Close streams
            is.close();
            sis.close();
        }

        return fileContents;
    },

    // Writes the specified contents into the specified file in the profile chrome directory
    writeUserChromeFile : function (fileName, fileContents) {
        var file = Flashblock.getUserChromeFile(fileName);
        var ioFlags = this.MODE_WRONLY | this.MODE_CREATE | this.MODE_TRUNCATE;
        var perm = 0644;

        var os = Components.classes["@mozilla.org/network/file-output-stream;1"]
                           .createInstance( Components.interfaces.nsIFileOutputStream);
        os.init(file, ioFlags, perm, 0);

        var result = os.write(fileContents, fileContents.length);
        os.close();

        return result;
    },

    // Checks the if the user stylesheet already contains the import statement
    userStyleSheetHasImport : function () {
        var fileContents = Flashblock.readUserChromeFile('userContent.css');
        var re = new RegExp("^[ \t]*@import.*chrome://flashblock/content/flashblock.css", "m");

        return re.test(fileContents);
    },

    // Adds a CSS import statement for the flashblock stylesheet
    addImportToUserStylesheet : function (fileName) {
        var importStr = "@import url(chrome://flashblock/content/flashblock.css);"

        var fileContents = Flashblock.readUserChromeFile('userContent.css');
        var re = new RegExp("^[ \t]*@import.*chrome://flashblock/content/flashblock.css", "m");

        if(re.test(fileContents))
            return true;

        fileContents = importStr + "\n" + fileContents;

        var ret = Flashblock.writeUserChromeFile(fileName, fileContents);
        return (ret == fileContents.length);
    },

    // Removes the CSS import statement for the flashblock stylesheet
    removeImportFromUserStylesheet : function (fileName) {
        var fileContents = Flashblock.readUserChromeFile(fileName);
        var re = new RegExp("^[ \t]*@import.*chrome://flashblock/content/flashblock.css.*(\n)?$", "mg");

        if(re.test(fileContents)) {
            fileContents = fileContents.replace(re, '');
            var ret = Flashblock.writeUserChromeFile(fileName, fileContents);
            return (ret == fileContents.length)
        } else {
            return true;
        }
    },


/// PREF FUNCTIONS
	// was flashblockPrefObserver
	prefObserver : {
		observe: function(subject, topic, data) {
			if(data == "flashblock.whitelist")
				Flashblock.loadWhitelist();
			if(data == "flashblock.enabled") {
				gFlashblockEnabled = Flashblock.isEnabled();
				Flashblock.setButtonState(gFlashblockEnabled);
			}
			if(data == "javascript.enabled") {
				Flashblock.setButtonState(gFlashblockEnabled);
			}
		},

		QueryInterface : function (aIID) {
			if (aIID.equals(Components.interfaces.nsIObserver) || 
				aIID.equals(Components.interfaces.nsISupports) ||
				aIID.equals(Components.interfaces.nsISupportsWeakReference))
				return this;
			throw Components.results.NS_NOINTERFACE;
		}
	},

	// was addFlashblockPrefObserver
	addPrefObserver : function () {
		var prefs = Components.classes["@mozilla.org/preferences-service;1"]
					.getService(Components.interfaces.nsIPrefBranch);

		var pbi = prefs.QueryInterface(Components.interfaces.nsIPrefBranchInternal);
		pbi.addObserver("flashblock.enabled", Flashblock.prefObserver, true);
		pbi.addObserver("flashblock.whitelist", Flashblock.prefObserver, true);
		pbi.addObserver("javascript.enabled", Flashblock.prefObserver, true);
	},


/// WHITELIST FUNCTIONS

	// Loads the whitelist into the global array
	loadWhitelist : function () {
		var flashblockPref = getWhitelistPref();
		gFlashblockWhitelist = new Array();
		if (flashblockPref)
		    gFlashblockWhitelist = flashblockPref.split(",");
	},

	checkHostInWhitelist : function (host) {
		for (var i = 0; i < gFlashblockWhitelist.length; i++) {
			// Handle *
			var expr = gFlashblockWhitelist[i];
			expr = expr.replace(/\./g, "\\.");
			expr = expr.replace(/\-/g, "\\-");
			expr = expr.replace(/\*/g, "[A-Za-z0-9_\\-\\.]*")
			expr = expr + "$"; // "^" + 

			var re = new RegExp(expr);
			if(re.test(host))
				return true;
		}
		return false;
	},

	checkWhitelist : function (url) {
		if(!isLocalBlocked()) {
			if(url.protocol == "file:")
				return true;
		}

		return this.checkHostInWhitelist(url.host);
	},

	checkLoadFlash : function (e) {
		if(! gFlashblockEnabled || Flashblock.checkWhitelist(e.target.location))
			e.preventDefault();
		e.stopPropagation();
	},

	// Gets the hostname from the URI of the current page
	getHost : function () {
		var pageURI;
		if ("gContextMenu" in window && gContextMenu)
			pageURI = gContextMenu.target.baseURI;
		else
			pageURI = content.location;

		// Work around about: and file:// URIs.
		// If we do uri.spec = "about:blank", the URI ends up as about://blank/
		if(/about:|file:|news:|snews:/i.test(pageURI.protocol))
			return undefined;

		var uri = Components.classes['@mozilla.org/network/standard-url;1']
			.createInstance(Components.interfaces.nsIURI);
		uri.spec = pageURI;

		// Phil: use asciiHost until we change the pref from char to complex
		var host = uri.asciiHost;
		if (uri.port > 0)
			host += ":" + uri.port;

		return host;
	},

	// Adds the host of the current URI to the whitelist
	addSiteToWhitelist : function () {
		var host = this.getHost();
		if( (!host) || (host == "") )
			return;

		var prefStr = getWhitelistPref();
		var re = new RegExp("(^|,)" + host + "(,|$)");
		if(! re.test(prefStr)) {
			if(prefStr && prefStr.length > 0)
				prefStr += "," + host;
			else
				prefStr = host;
			setWhitelistPref(prefStr);
		}
	},

	// Removes the host of the current URI from the whitelist
	removeSiteFromWhitelist : function () {
		var host = this.getHost();
		if( (!host) || (host == "") )
			return;

		var prefStr = getWhitelistPref();
		var regex = new RegExp("(^|,)(" + host + ")(,|$)", "g");

		prefStr = prefStr.replace(regex, "$3");
		setWhitelistPref(prefStr);
	},

	// Toggles the whitelist status of the host of the current URI
	toggleSiteWhitelisted : function () {
		host = this.getHost();
		if(this.checkHostInWhitelist(host))
			this.removeSiteFromWhitelist();
		else
			this.addSiteToWhitelist();
	},


/// CONTEXT MENU FUNCTIONS

    contextMenuInit : function () {
        var cm = document.getElementById("contentAreaContextMenu");
        if (cm)
            cm.addEventListener("popupshowing",Flashblock.contextMenu,false);

        cm = document.getElementById("messagePaneContext");
        if (cm)
            cm.addEventListener("popupshowing",Flashblock.contextMenu,false);
        Flashblock.setButtonState(isEnabled());
    },

    // was flashblockContextMenu()
    contextMenu : function () {
      var cm = gContextMenu;
      var onFlash = cm.hasBGImage &&
        cm.bgImageURL.indexOf("chrome://flashblock") == 0;
      var nukeItem = document.getElementById("nukeanything-do-nuke");

      var itemsToShow = ["context-flashAllow", "context-flashLocation", "context-flashWhitelist"];
      for (var ii = 0; ii < itemsToShow.length; ii++) {
        cm.showItem(itemsToShow[ii], onFlash);
      }
      cm.showItem("context-flashRemove", onFlash && !nukeItem);

      if (onFlash) {
        var itemsToHide = ["context-back", "context-forward", "context-reload",
          "context-stop", "context-sep-stop",
          "context-bookmarkpage", "context-savepage", "context-sendpage",
          "context-viewbgimage", "context-viewbgimage-menu", "context-sep-viewbgimage", 
          "context-selectall", "context-viewsource", "context-viewinfo",
          "context-metadata", "context-sep-properties",
          "switchToTrident", "context-print" ];

        var itemsToHide2 = ["messagePaneContext-sep-open",
          "messagePaneContext-replySender", "messagePaneContext-replyNewsgroup",
          "messagePaneContext-replyAll", "messagePaneContext-forward",
          "messagePaneContext-editAsNew", "messagePaneContext-sep-reply",
          "messagePaneContext-copyMessageUrl", "messagePaneContext-moveMenu",
          "messagePaneContext-copyMenu", "messagePaneContext-sep-tags",
          "messagePaneContext-tags", "messagePaneContext-mark",
          "messagePaneContext-sep-mark", "messagePaneContext-saveAs",
          "messagePaneContext-printpreview", "messagePaneContext-print",
          "messagePaneContext-delete" ];
        itemsToHide = itemsToHide.concat(itemsToHide2);

        for (var ii = 0; ii < itemsToHide.length; ii++) {
          cm.showItem(itemsToHide[ii], false);
        }

        var thisURI = Components.classes['@mozilla.org/network/standard-url;1']
            .createInstance(Components.interfaces.nsIURI);
        thisURI.spec = gContextMenu.target.baseURI;
        document.getElementById("context-flashAllow")
          .setAttribute("tooltiptext", thisURI.prePath);

        var cmLocationItem = document.getElementById("context-flashLocation");
        if (cmLocationItem && gContextMenu.target.title) {
          cmLocationItem.setAttribute("tooltiptext",
                                      Flashblock.getAbsoluteURL(gContextMenu.target));
        }

        Flashblock.checkWhitelistToggle();
      }
    },

    getAbsoluteURL : function(target) {
        var absURL = target.title;
        if (!/^http(s?):/i.test(absURL)) {
          var ios = Components.classes["@mozilla.org/network/io-service;1"]
                              .getService(Components.interfaces.nsIIOService);
          var baseURI  = ios.newURI(target.baseURI, null, null);
          absURL = ios.newURI(baseURI.resolve(absURL), null, null).spec;
        }
        return absURL;
    },

    // was flashblockOptions()
    showOptions : function() {
        window.openDialog("chrome://flashblock/content/options.xul",
            "FlashblockOptions", "chrome,titlebar,toolbar,centerscreen,resizable");
    },

    copyLocation : function() {
      var clipboard = Components.classes["@mozilla.org/widget/clipboardhelper;1"]
                      .getService(Components.interfaces.nsIClipboardHelper);
      clipboard.copyString(Flashblock.getAbsoluteURL(gContextMenu.target));
    },

/// INITIALIZATION CODE
    onInstall : function() {
        window.removeEventListener("load", Flashblock.onInstall, true);

        if("@mozilla.org/content/style-sheet-service;1" in Components.classes) {
          // we have the new stylesheet api!
          var sss = Components.classes["@mozilla.org/content/style-sheet-service;1"]
                    .getService(Components.interfaces.nsIStyleSheetService);
          var ios = Components.classes["@mozilla.org/network/io-service;1"]
                    .getService(Components.interfaces.nsIIOService);
          var u = ios.newURI("chrome://flashblock/content/flashblock.css", null, null);
          if(!sss.sheetRegistered(u, sss.USER_SHEET)) {
            sss.loadAndRegisterSheet(u, sss.USER_SHEET);
            dump("installing flashblock\n");
          }
        }
        else {
          if(! Flashblock.userStyleSheetHasImport()) {
            Flashblock.addImportToUserStylesheet('userContent.css');
            var flashblockBundle = document.getElementById("bundle_flashblock");
            var brandBundle = document.getElementById("bundle_brand");
            var brandShortName = brandBundle.getString("brandShortName");
            var msg = flashblockBundle.getFormattedString("flashblockInstalled",
                                                          [brandShortName]);
            alert(msg);
          }
        }
    },


/// TOOLBARBUTTON CODE

  //was flashblockToggleButton()
    toggleButton : function(event) {
        var state = !gFlashblockEnabled;
        setEnabled(state);
        Flashblock.setButtonState(state);
        if (event.metaKey || event.ctrlKey || event.shiftKey) {
            BrowserReload();
        }
    },

  //was flashblockSetButtonState(state)
    setButtonState : function(state) {
        var button = document.getElementById("flashblockToggle-button");
        if (button != null) {
            button.setAttribute("state", state? "enabled" : "disabled");
            button.setAttribute("disabled", isJavascriptEnabled()?
                                "false" : "true");
        }
        button = document.getElementById("flashblockMozToggle-button");
        if (button != null) {
            button.setAttribute("state", state? "enabled" : "disabled");
            button.setAttribute("disabled", isJavascriptEnabled()?
                                "false" : "true");
        }
    },

    setTooltipSite : function() {
		var thisURI = Components.classes['@mozilla.org/network/standard-url;1']
			.createInstance(Components.interfaces.nsIURI);
        thisURI.spec = content.location;
        var menu = document.getElementById("buttonmenu-flashblockAllow");
        if (menu) { 
            menu.setAttribute("tooltiptext", thisURI.prePath)
        };
        menu = document.getElementById("buttonmenu-flashblockAllowMoz");
        if (menu) { 
            menu.setAttribute("tooltiptext", thisURI.prePath)
        };
    },

    // workaround for bug 147670
    fixParentTip : function(state, pnode) {
        var tip;
        if (state == "hide") {
            tip = pnode.getAttribute("tooltiptext");
            if (tip) {
                pnode.setAttribute("temptip", tip);
                pnode.removeAttribute("tooltiptext");
            };
            Flashblock.setTooltipSite();
        } else if (state == "show") {
            tip = pnode.getAttribute("temptip");
            if (tip) {
                pnode.setAttribute("tooltiptext", tip);
                pnode.removeAttribute("temptip");
            };
        }
    },

	checkWhitelistToggle : function () {
		var host = this.getHost();
		var toolbarWhitelistItem = document.getElementById("buttonmenu-flashblockAllow");
		var toolbarWhitelistItemMoz = document.getElementById("buttonmenu-flashblockAllowMoz");
		var contextmenuWhitelistItem = document.getElementById("context-flashAllow");

		if(host) {
			var whitelisted = this.checkHostInWhitelist(host);
			contextmenuWhitelistItem.setAttribute("disabled", false);
			if(toolbarWhitelistItem) {
				toolbarWhitelistItem.setAttribute("disabled", false);
				toolbarWhitelistItem.setAttribute("checked", whitelisted)
			}
			if(toolbarWhitelistItemMoz) {
				toolbarWhitelistItemMoz.setAttribute("disabled", false);
				toolbarWhitelistItemMoz.setAttribute("checked", whitelisted)
			}

			var thisURI = Components.classes['@mozilla.org/network/standard-url;1']
				.createInstance(Components.interfaces.nsIURI);
			if ("gContextMenu" in window && gContextMenu) {
				thisURI.spec = gContextMenu.target.baseURI;
			} else {
				thisURI.spec = content.location;
			}
			whitelisted = this.checkHostInWhitelist(thisURI.host);
			contextmenuWhitelistItem.setAttribute("checked", whitelisted);
		} else {
			contextmenuWhitelistItem.setAttribute("disabled", true);
			if(toolbarWhitelistItem)
				toolbarWhitelistItem.setAttribute("disabled", true);
			if(toolbarWhitelistItemMoz)
				toolbarWhitelistItemMoz.setAttribute("disabled", true);
		}
    },

/// MISC

    //was flashblockHideObject()
    hideObject : function() {
        if(gContextMenu) {
            var obj = gContextMenu.target;
            if(obj) {
                obj.style.display = "none";
            }
        }
    },

    // the isEnabled() function in flashblock-prefs.js seems to go out of scope 
    isEnabled : function() {
        var prefs = Components.classes["@mozilla.org/preferences-service;1"]
                              .getService(Components.interfaces.nsIPrefBranch);

        if(prefs.getPrefType("flashblock.enabled") == prefs.PREF_BOOL)
            return prefs.getBoolPref("flashblock.enabled");
        else
        	return true;
    }
}

var gFlashblockWhitelist;
var gFlashblockEnabled;

Flashblock.addPrefObserver();
Flashblock.loadWhitelist();
gFlashblockEnabled = Flashblock.isEnabled();

window.addEventListener("load", Flashblock.onInstall, true);
window.addEventListener("load", Flashblock.contextMenuInit, true);
window.addEventListener("flashblockCheckLoad", Flashblock.checkLoadFlash, true, true)
