#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
#include <unistd.h>
#include <getopt.h>
#include <string.h>
#include <fcntl.h>
#include <signal.h>
#include <errno.h>
#include <string.h>
#include <limits.h>
#include <sys/types.h>
#include <pwd.h>
#include <sys/time.h>

#include "header.h"
#include "sql_query.h"

// Those membervars need to be filled prior calling:
// headerSize;
// headerNumLines;
// headerLines[MAX_HEADER_LINE];
// headerLinesSize[MAX_HEADER_LINE];

int mini(int a,int b){
	if(b < a)	return b;
	else	return a;
}

tErr getHeaderFields(header* head){
	char *p1,*p2,*p3,*p4;
	char* temp_buf,*tmp;
	unsigned long i;


	testQuery();
	// make a copy of the header
	head->m_buffer = (char*)malloc(head->m_headerSize+1);
	memcpy(head->m_buffer,head->m_msgbuf,head->m_headerSize);
	p1 = head->m_buffer + head->m_headerSize;
	*p1 = 0;
	for(i=0;i<head->m_headerNumLines;i++){
		// separate lines into independant strings
		head->m_buffer[ head->m_headerLines[i] + head->m_headerLinesSize[i] - 1 ] = 0;
		// Find interesting header fields...
 		fprintf(stderr,"%ld:%s\n",i,head->m_buffer+head->m_headerLines[i]);
		if( !strncmp("From:",head->m_buffer+head->m_headerLines[i],mini(head->m_headerLinesSize[i],strlen("From:"))) )
			head->m_From_feild = head->m_buffer+head->m_headerLines[i] + strlen("From:");
		else if( !strncmp("To:",head->m_buffer+head->m_headerLines[i],mini(head->m_headerLinesSize[i],strlen("To:"))) )
			head->m_To_feild = head->m_buffer+head->m_headerLines[i] + strlen("To:");
		else if( !strncmp("Cc:",head->m_buffer+head->m_headerLines[i],mini(head->m_headerLinesSize[i],strlen("Cc:"))) )
			head->m_Cc_feild = head->m_buffer+head->m_headerLines[i] + strlen("Cc:");
		else if( !strncmp("Bcc:",head->m_buffer+head->m_headerLines[i],head->m_headerLinesSize[i]) )
			head->m_Bcc_feild = head->m_buffer+head->m_headerLines[i] + strlen("Bcc:");
		else if( !strncmp("Delivered-To:",head->m_buffer+head->m_headerLines[i],mini(head->m_headerLinesSize[i],strlen("Delivered-To:"))) && head->m_DeliveredTo_feild == NULL)
			head->m_DeliveredTo_feild = head->m_buffer+head->m_headerLines[i] + strlen("Delivered-To:");
		else if( !strncmp("Return-Path:",head->m_buffer+head->m_headerLines[i],mini(head->m_headerLinesSize[i],strlen("Return-Path:"))) && head->m_ReturnPath_feild == NULL)
			head->m_ReturnPath_feild = head->m_buffer+head->m_headerLines[i] + strlen("Return-Path:");
		else if( !strncmp("Subject:",head->m_buffer+head->m_headerLines[i],head->m_headerLinesSize[i]) && head->m_Subject_feild == NULL)
			head->m_Subject_feild = head->m_buffer+head->m_headerLines[i] + strlen("Subject:");
		else if( !strncmp("\tby localhost with POP3 (fetchmail-5.9.11 polling ",head->m_buffer+head->m_headerLines[i],mini(head->m_headerLinesSize[i],strlen("\tby localhost with POP3 (fetchmail-5.9.11 polling ")) )){
			temp_buf = strdup(head->m_buffer+head->m_headerLines[i]+strlen("\tby localhost with POP3 (fetchmail-5.9.11 polling "));
			p1 = temp_buf;
			if( (p2 = strstr(p1," account ")) == NULL)	return INCONSISTENT_MESSAGE;
			*p2 = 0;
			p3 = p2 + strlen(" account ");
			if( (p4 = strstr(p3,")")) == NULL)	return INCONSISTENT_MESSAGE;
			*p4 = 0;
			head->m_fetchmail_server_addr = strdup(p1);
			head->m_fetchmail_username = strdup(p3);
			free(temp_buf);
 			fprintf(stderr,"[igw]login:%s/srv:%s/",head->m_fetchmail_username,head->m_fetchmail_server_addr);
		}
	}

	// Check there is at least a sender and a recipient
	if(head->m_From_feild==NULL || head->m_DeliveredTo_feild==NULL ||
	(head->m_To_feild==NULL && head->m_Cc_feild==NULL && head->m_Bcc_feild==NULL)){
		return INCONSISTENT_MESSAGE;
	}
	if(	strlen(head->m_From_feild) < 6 ||
		!strstr(head->m_DeliveredTo_feild,"@iglobalwall.com") ||
		!strstr(head->m_DeliveredTo_feild,"iglobalwall-com-") ||
		((head->m_To_feild!=NULL && strlen(head->m_To_feild) < 6) &&
		(head->m_Cc_feild!=NULL && strlen(head->m_Cc_feild) < 6) &&
		(head->m_Bcc_feild!=NULL && strlen(head->m_Bcc_feild) < 6))){
		return INCONSISTENT_MESSAGE;
	}
	// Find user in the first DeliveredTo feild
	tmp = strdup(head->m_DeliveredTo_feild);
	p1 = strstr(tmp,"iglobalwall-com-");
	if(p1 == NULL) return INCONSISTENT_MESSAGE;
	p1 += strlen("iglobalwall-com-");
	p2 = strstr(p1,"@iglobalwall.com");
	if(p2 == NULL)	return INCONSISTENT_MESSAGE;
	*p2 = 0;
	head->m_iWall_user = strdup(p1);
	free(tmp);
	return noErr;
}
