/*
 * Danpei -- a GTK+ based Image Viewer
 * Copyright (C) 2001-2003 Shinji Moiino
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
/* thumbnail_menu.c */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <gdk/gdkx.h>

#include "config.h"
#include "dirtree.h"
#include "intl.h"
#include "main.h"
#include "thumbnail_menu.h"
#include "thumbnail_table.h"
#include "version.h"

/* Static function declarations. */

/* Function definitions. */
/*
 * @thumbnail_menu_cb_size_small_activate
 *
 *
 *
 */
void thumbnail_menu_cb_size_small_activate(GtkWidget *widget,
                                           gpointer  data     ){
  TopLevel *tp;

  tp = (TopLevel*)data;

  if ((GTK_CHECK_MENU_ITEM(widget))->active == TRUE) {
    tp->current_icon_size = ICON_SMALL;
    if (tp->thumbnail_table.dir_name == NULL) {
      return;
    }
    else {
      thumbnail_table_refresh(tp);
    }
  }

  return;
}

/*
 * @thumbnail_menu_cb_size_middle_activate
 *
 *
 *
 */
void thumbnail_menu_cb_size_middle_activate(GtkWidget *widget,
                                            gpointer  data     ){
  TopLevel *tp;

  tp = (TopLevel*)data;

  if ((GTK_CHECK_MENU_ITEM(widget))->active == TRUE) {
    tp->current_icon_size = ICON_MIDDLE;
    if (tp->thumbnail_table.dir_name == NULL) {
      return;
    }
    else {
      thumbnail_table_refresh(tp);
    }
  }

  return;
}

/*
 * @thumbnail_menu_cb_size_large_activate
 *
 *
 *
 */
void thumbnail_menu_cb_size_large_activate(GtkWidget *widget,
                                           gpointer  data     ){
  TopLevel *tp;

  tp = (TopLevel*)data;

  if ((GTK_CHECK_MENU_ITEM(widget))->active == TRUE) {
    tp->current_icon_size = ICON_LARGE;
    if (tp->thumbnail_table.dir_name == NULL) {
      return;
    }
    else {
      thumbnail_table_refresh(tp);
    }
  }

  return;
}

/*
 * @thumbnail_menu_cb_format_button_toggled
 *
 *
 *
 */
void thumbnail_menu_cb_format_button_toggled(GtkWidget *widget,
                                             gpointer  data     ){
  TopLevel  *tp;

  tp = (TopLevel*)data;

  if (strcmp(gtk_widget_get_name(widget), "CHECK_MENU_ITEM_JPEG") == 0) {
    if (GTK_CHECK_MENU_ITEM(widget)->active) {
      tp->current_format.jpg_on = TRUE;
    }
    else {
      tp->current_format.jpg_on = FALSE;
    }
    thumbnail_table_refresh(tp);
    return;
  }
  if (strcmp(gtk_widget_get_name(widget), "CHECK_MENU_ITEM_BMP") == 0) {
    if (GTK_CHECK_MENU_ITEM(widget)->active) {
      tp->current_format.bmp_on = TRUE;
    }
    else {
      tp->current_format.bmp_on = FALSE;
    }
    thumbnail_table_refresh(tp);
    return;
  }
  if (strcmp(gtk_widget_get_name(widget), "CHECK_MENU_ITEM_PNG") == 0) {
    if (GTK_CHECK_MENU_ITEM(widget)->active) {
      tp->current_format.png_on = TRUE;
    }
    else {
      tp->current_format.png_on = FALSE;
    }
    thumbnail_table_refresh(tp);
    return;
  }
  if (strcmp(gtk_widget_get_name(widget), "CHECK_MENU_ITEM_XPM") == 0) {
    if (GTK_CHECK_MENU_ITEM(widget)->active) {
      tp->current_format.xpm_on = TRUE;
    }
    else {
      tp->current_format.xpm_on = FALSE;
    }
    thumbnail_table_refresh(tp);
    return;
  }
  if (strcmp(gtk_widget_get_name(widget), "CHECK_MENU_ITEM_TIFF") == 0) {
    if (GTK_CHECK_MENU_ITEM(widget)->active) {
      tp->current_format.tif_on = TRUE;
    }
    else {
      tp->current_format.tif_on = FALSE;
    }
    thumbnail_table_refresh(tp);
    return;
  }
  if (strcmp(gtk_widget_get_name(widget), "CHECK_MENU_ITEM_XBM") == 0) {
    if (GTK_CHECK_MENU_ITEM(widget)->active) {
      tp->current_format.xbm_on = TRUE;
    }
    else {
      tp->current_format.xbm_on = FALSE;
    }
    thumbnail_table_refresh(tp);
    return;
  }
  if (strcmp(gtk_widget_get_name(widget), "CHECK_MENU_ITEM_GIF") == 0) {
    if (GTK_CHECK_MENU_ITEM(widget)->active) {
      tp->current_format.gif_on = TRUE;
    }
    else {
      tp->current_format.gif_on = FALSE;
    }
    thumbnail_table_refresh(tp);
    return;
  }
  if (strcmp(gtk_widget_get_name(widget), "CHECK_MENU_ITEM_PCX") == 0) {
    if (GTK_CHECK_MENU_ITEM(widget)->active) {
      tp->current_format.pcx_on = TRUE;
    }
    else {
      tp->current_format.pcx_on = FALSE;
    }
    thumbnail_table_refresh(tp);
    return;
  }

  return;
}

/*
 * @thumbnail_menu_cb_sort_file_activate
 *
 *
 *
 */
void thumbnail_menu_cb_sort_file_activate(GtkWidget *widget,
                                          gpointer  data     ){
  TopLevel *tp;

  tp = (TopLevel*)data;

  if ((GTK_CHECK_MENU_ITEM(widget))->active == TRUE) {
    tp->current_sort_order = SORT_FILE_NAME_A;
    if (tp->thumbnail_table.dir_name == NULL) {
      return;
    }
    else {
      thumbnail_table_refresh(tp);
    }
  }

  return;
}

/*
 * @thumbnail_menu_cb_sort_ctime_activate
 *
 *
 *
 */
void thumbnail_menu_cb_sort_ctime_activate(GtkWidget *widget,
                                           gpointer  data     ){
  TopLevel *tp;

  tp = (TopLevel*)data;

  if ((GTK_CHECK_MENU_ITEM(widget))->active == TRUE) {
    tp->current_sort_order = SORT_CTIME_A;
    if (tp->thumbnail_table.dir_name == NULL) {
      return;
    }
    else {
      thumbnail_table_refresh(tp);
    }
  }

  return;
}

/*
 * @thumbnail_menu_cb_sort_atime_activate
 *
 *
 *
 */
void thumbnail_menu_cb_sort_atime_activate(GtkWidget *widget,
                                           gpointer  data     ){
  TopLevel *tp;

  tp = (TopLevel*)data;

  if ((GTK_CHECK_MENU_ITEM(widget))->active == TRUE) {
    tp->current_sort_order = SORT_ATIME_A;
    if (tp->thumbnail_table.dir_name == NULL) {
      return;
    }
    else {
      thumbnail_table_refresh(tp);
    }
  }

  return;
}

/*
 * @thumbnail_menu_cb_sort_mtime_activate
 *
 *
 *
 */
void thumbnail_menu_cb_sort_mtime_activate(GtkWidget *widget,
                                           gpointer  data     ){
  TopLevel *tp;

  tp = (TopLevel*)data;

  if ((GTK_CHECK_MENU_ITEM(widget))->active == TRUE) {
    tp->current_sort_order = SORT_MTIME_A;
    if (tp->thumbnail_table.dir_name == NULL) {
      return;
    }
    else {
      thumbnail_table_refresh(tp);
    }
  }

  return;
}

/*
 * @thumbnail_menu_cb_sort_ascend_activate
 *
 *
 *
 */
void thumbnail_menu_cb_sort_ascend_activate(GtkWidget *widget,
                                            gpointer  data     ){
  TopLevel *tp;

  tp = (TopLevel*)data;

  if ((GTK_CHECK_MENU_ITEM(widget))->active == TRUE) {
    switch (tp->current_sort_order) {
      case SORT_FILE_NAME_D:
        tp->current_sort_order = SORT_FILE_NAME_A;
        break;
      case SORT_CTIME_D:
        tp->current_sort_order = SORT_CTIME_A;
        break;
      case SORT_ATIME_D:
        tp->current_sort_order = SORT_ATIME_A;
        break;
      case SORT_MTIME_D:
        tp->current_sort_order = SORT_MTIME_A;
        break;
      case SORT_FILE_NAME_A:
      case SORT_CTIME_A    :
      case SORT_ATIME_A    :
      case SORT_MTIME_A    :
        break;
    }

    if (tp->thumbnail_table.dir_name == NULL) {
      return;
    }
    else {
      thumbnail_table_refresh(tp);
    }
  }

  return;
}

/*
 * @thumbnail_menu_cb_sort_descend_activate
 *
 *
 *
 */
void thumbnail_menu_cb_sort_descend_activate(GtkWidget *widget,
                                             gpointer  data     ){
  TopLevel *tp;

  tp = (TopLevel*)data;

  if ((GTK_CHECK_MENU_ITEM(widget))->active == TRUE) {
    switch (tp->current_sort_order) {
      case SORT_FILE_NAME_A:
        tp->current_sort_order = SORT_FILE_NAME_D;
        break;
      case SORT_CTIME_A:
        tp->current_sort_order = SORT_CTIME_D;
        break;
      case SORT_ATIME_A:
        tp->current_sort_order = SORT_ATIME_D;
        break;
      case SORT_MTIME_A:
        tp->current_sort_order = SORT_MTIME_D;
        break;
      case SORT_FILE_NAME_D:
      case SORT_CTIME_D    :
      case SORT_ATIME_D    :
      case SORT_MTIME_D    :
        break;
    }

    if (tp->thumbnail_table.dir_name == NULL) {
      return;
    }
    else {
      thumbnail_table_refresh(tp);
    }
  }

  return;
}



