//
// File:        ParseSymbolException.java
// Package:     gov.llnl.babel.parsers.xml
// Revision:    @(#) $Id: ParseSymbolException.java 4763 2005-07-26 17:32:19Z kumfert $
// Description: exception for format errors in XML/DOM symbol representations
//
// Copyright (c) 2000-2001, The Regents of the University of Calfornia.
// Produced at the Lawrence Livermore National Laboratory.
// Written by the Components Team <components@llnl.gov>
// UCRL-CODE-2002-054
// All rights reserved.
// 
// This file is part of Babel. For more information, see
// http://www.llnl.gov/CASC/components/. Please read the COPYRIGHT file
// for Our Notice and the LICENSE file for the GNU Lesser General Public
// License.
// 
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU Lesser General Public License (as published by
// the Free Software Foundation) version 2.1 dated February 1999.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the IMPLIED WARRANTY OF
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the terms and
// conditions of the GNU Lesser General Public License for more details.
// 
// You should have recieved a copy of the GNU Lesser General Public License
// along with this program; if not, write to the Free Software Foundation,
// Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA

package gov.llnl.babel.parsers.xml;

/**
 * The <code>ParseSymbolException</code> exception class is thrown if an
 * error is detected while parsing an XML/DOM symbol representation.  It
 * is thrown if (1) the DOM parser detects an error or (2) the internal
 * DOM representation is invalid.
 */
public class ParseSymbolException  extends Exception {
   /**
	 * 
	 */
	private static final long serialVersionUID = 4837147682889133035L;

/**
    * Create a new <code>ParseSymbolException</code> exception with the
    * specified message string.
    */
   public ParseSymbolException(String message) {
      super(message);
   }
}
