
/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#ifndef RP_BUILDERS_H
#define RP_BUILDERS_H

#include <rp_algorithmsuite_builder.h>
#include <rp_defines.h>
#include <rp_layout_builder.h>
#include <rp_supporting_tokens_builder.h>
#include <rp_token_identifier.h>
#include <rp_transport_binding_builder.h>
#include <rp_transport_token_builder.h>
#include <rp_username_token_builder.h>
#include <rp_wss10_builder.h>
#include <rp_wss11_builder.h>
#include <rp_trust10_builder.h>
#include <rp_qname_matcher.h>
#include <rp_https_token_builder.h>
#include <rp_x509_token_builder.h>
#include <rp_issued_token_builder.h>
#include <rp_saml_token_builder.h>
#include <rp_security_context_token_builder.h>
#include <rp_bootstrap_policy_builder.h>
#include <rp_recipient_token_builder.h>
#include <rp_initiator_token_builder.h>
#include <rp_asymmetric_binding_builder.h>
#include <rp_signed_encrypted_parts_builder.h>
#include <rp_rampart_config_builder.h>
#include <rp_symmetric_binding_builder.h>
#include <rp_protection_token_builder.h>
#include <rp_encryption_token_builder.h>
#include <rp_signature_token_builder.h>

/**
* @file rp_builders.h
* @all the secpolicy builders
*/
#ifdef __cplusplus
extern "C"
{
#endif

    /** @} */

#ifdef __cplusplus
}
#endif

#endif                          /*RP_BUILDERS_H */
