
using System;
using System.Collections;


public class TestKDTree
{
	public static void Main (string[] args)
	{
		ArrayList points = new ArrayList ();

		for (int n = 0 ; n < 131072 ; ++n) {
			Point pt = Point.CreateRandomPoint (-10.0, 10.0, -10.0, 10.0);
			Console.WriteLine ("P {0} {1}", pt.X, pt.Y);
			points.Add (pt);
		}
		//Console.WriteLine ("\nbuilding kd-tree");

		KDTree kd = KDTree.CreateKDTree (points);

		// try searching for a random target
		Point target = Point.CreateRandomPoint (-10.0, 10.0, -10.0, 10.0);

		Console.WriteLine ("searching for\nS {0} {1}", target.X, target.Y);
		double dist;
		Point NN = (Point) kd.NearestNeighbour (target, out dist);

		if (NN == null) {
			Console.WriteLine ("no nn found");
		} else {
			Console.WriteLine ("nearest is (distance {0}):\nN {1} {2}",
				dist, NN.X, NN.Y);
		}
	}
}


// 2d example point class
public class Point : IKDTreeDomain
{
	public int DimensionCount {
		get {
			return (2);
		}
	}

	public double GetDimensionElement (int dim)
	{
		return (coords[dim]);
	}

	double[] coords = new double[2];
	public double X {
		get {
			return (coords[0]);
		}
	}
	public double Y {
		get {
			return (coords[1]);
		}
	}

	private Point ()
	{
	}

	public Point (double x, double y)
	{
		coords[0] = x;
		coords[1] = y;
	}

	static Random rnd = new Random ();
	static public Point CreateRandomPoint (double minX, double maxX,
		double minY, double maxY)
	{
		double x = rnd.NextDouble () * (maxX - minX) + minX;
		double y = rnd.NextDouble () * (maxY - minY) + minY;

		return (new Point (x, y));
	}
}

