
//#define DEBUG 1

#ifndef DEBUG
#undef LOCAL_DEBUG
#endif

#define DBGUSER 1
#define DBGEXPERT 2
#define DBGSPAM 3


#ifdef LOCAL_DEBUG

#include "aclogger.h"
#include "acfg.h"

#include <assert.h>
#include <iostream>
#include <sstream>
#include <meta.h>

// convinient methods and such with vl, minimum verbosity level 
#define ldbg_always(x) { const char *p=strrchr(__FILE__, cPathSep); p=p?(p+1):__FILE__; MYSTD::ostringstream __oss;\
	__oss << p <<":"<<__LINE__ <<"("<< pthread_self() << ") | "<< x; aclog::err(__oss.str().c_str());}
#define dbgline_always { ldbg(__FILE__ << ": " << __LINE__); }
//#define ldbg(x) { MYSTD::cerr << x << MYSTD::endl;}
//#define dbgline { MYSTD::cerr << __FILE__ << ": " << __LINE__ << MYSTD::endl;}
#define ASSERT(x) assert(x)

/*
#define ldbgvl(v, x) { if(v<=CFG->debug) {ldbg_always(x);} }
#define dbglvl(v) { if(v<=CFG->debug) { dbgline_always ; } }
*/

#define ldbg(x) { ldbg_always(x); }
#define dbgline { dbgline_always ; }

#else

#define ldbg_always(x)
#define dbgline_always
#define ldbgvl(v, x)
#define dbglvl(v)
#define ldbg(x)
#define dbgline
#define ASSERT(x)
#endif



