/* Copyright (C) 2002, 2003, 2004 Jan Wedekind.
   This file is part of the recipe database application AnyMeal.

   AnyMeal is free software; you can redistribute it and/or modify it under
   the terms of the GNU GENERAL PUBLIC LICENSE as published by the Free
   Software Foundation; either version 2 of the License, or (at your option)
   any later version.

   AnyMeal is distributed in the hope that it will be useful, but WITHOUT ANY
   WARRANTY; without even the implied warranty of MERCHANTIBILITY or FITNESS
   FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
   details.

   You should have received a copy of the GNU General Public License along
   with AnyMeal; if not, contact one of the authors of this software. */
#include <sstream>
#include <sax/SAXParseException.hpp>
#include <Include/PlatformDefinitions.hpp>
#include "strX.hpp"
#include "xmlErrorHandler.hpp"

using namespace std;
// using namespace xercesc;

// XALAN_USING_XERCES(SAXParseException);

XMLErrorHandler::XMLErrorHandler(void):
  errorOccurred(false)
{
}

void XMLErrorHandler::warning( const SAXParseException &toCatch )
{
  // Ignore all warnings.
#ifndef NDEBUG
  cerr << createMessage( "Warning", toCatch ) << endl;
#endif
}

void XMLErrorHandler::error( const SAXParseException &toCatch )
{
  triggerError( "Error", toCatch );
}

void XMLErrorHandler::fatalError( const SAXParseException& toCatch)
{
  triggerError( "Fatal error", toCatch );
}

void XMLErrorHandler::resetErrors()
{
  errorOccurred = false;
  message.clear();
}

void XMLErrorHandler::triggerError( const std::string &type,
                                    const SAXParseException &toCatch )
{
  errorOccurred = true;
  ostringstream outputStream;
  if ( !message.empty() ) outputStream << message << endl;
  outputStream << createMessage( type, toCatch );
  message = outputStream.str();
}

std::string XMLErrorHandler::createMessage( const std::string &type,
                                            const SAXParseException &toCatch )
{
  ostringstream outputStream;
  outputStream << type << " at file \""
               << StrX<char,XMLCh>( toCatch.getSystemId() ).getBuffer()
               << "\", line " << toCatch.getLineNumber()
               << ", column " << toCatch.getColumnNumber()
               << ": "
               << StrX<char,XMLCh>( toCatch.getMessage() ).getBuffer();
  return outputStream.str();
}
