/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
 
#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gdk/gdkkeysyms.h>
#include <gtk/gtk.h>

#include "glade_support.h"
#include "prefs.h"
#if defined(HAVE_GNOME) || defined(G_OS_WIN32)
#  include "main.h" /* for my_open_browser() */
#endif

#define GLADE_HOOKUP_OBJECT(component,widget,name) \
  g_object_set_data_full (G_OBJECT (component), name, \
    gtk_widget_ref (widget), (GDestroyNotify) gtk_widget_unref)

static void
unlock_dialog_check(GtkDialog *dialog)
{
    const gchar *name, *code_str, *ptr;
    guint32 code;
    gboolean matches;
    GtkWidget *msg_dialog, *name_entry, *code_entry;

    name_entry = lookup_widget(GTK_WIDGET(dialog), N_("name_entry"));
    code_entry = lookup_widget(GTK_WIDGET(dialog), N_("code_entry"));
    name     = gtk_entry_get_text(GTK_ENTRY(name_entry));
    code_str = gtk_entry_get_text(GTK_ENTRY(code_entry));
    code = 0;
    for(ptr=code_str; *ptr; ++ptr) {
        if(*ptr < '0' || *ptr > '9') {
            matches = FALSE;
            goto checked;
        }
        code = code*10 + (*ptr-'0');
    }
    matches = check_regcode(name, code);
checked:
    if(matches) {
        GtkWindow *parent;

        parent = gtk_window_get_transient_for(GTK_WINDOW(dialog));
        gtk_widget_hide(GTK_WIDGET(dialog)); /* See below. */
        ini_settings_freeze_write(main_ini_file);
        g_object_set(G_OBJECT(gtk_settings_get_default()), N_("user-name"), (gpointer)name, NULL);
        g_object_set(G_OBJECT(gtk_settings_get_default()), N_("user-code"), (gpointer)code, NULL);
        ini_settings_thaw_write  (main_ini_file);
        msg_dialog = gtk_message_dialog_new(parent,
                                            GTK_DIALOG_MODAL|GTK_DIALOG_DESTROY_WITH_PARENT,
                                            GTK_MESSAGE_INFO,
                                            GTK_BUTTONS_CLOSE,
                                            _("Congratulations, it is registered!"));
    } else
        msg_dialog = gtk_message_dialog_new(GTK_WINDOW(dialog),
                                            GTK_DIALOG_MODAL|GTK_DIALOG_DESTROY_WITH_PARENT,
                                            GTK_MESSAGE_ERROR,
                                            GTK_BUTTONS_CLOSE,
                                            _("You've entered wrong code or name!"));
    gtk_dialog_run(GTK_DIALOG(msg_dialog));
    gtk_widget_destroy(msg_dialog);
    /* If I destroy dialogs in different order than reverse order of their creation,
       then not all dialogs are in fact destroyed. */
    if(matches) gtk_widget_destroy(GTK_WIDGET(dialog));
}

static void
on_unlock_dialog_response              (GtkDialog       *dialog,
                                        gint             response_id,
                                        gpointer         user_data)
{
    switch(response_id) {
#if defined(HAVE_GNOME) || defined(G_OS_WIN32)
        case 1:
            my_open_browser(N_("http://www.regnow.com/softsell/nph-softsell.cgi?item=5790-4"));
            break;
#endif
        case GTK_RESPONSE_OK:
            unlock_dialog_check(dialog);
            break;
        default:
            gtk_widget_destroy(GTK_WIDGET(dialog));
            return;
            break;
    }
}

GtkWidget*
create_unlock_dialog (void)
{
  GtkWidget *unlock_dialog;
  GtkWidget *dialog_vbox1;
  GtkWidget *vbox1;
  GtkWidget *label3;
  GtkWidget *table1;
  GtkWidget *label1;
  GtkWidget *label2;
  GtkWidget *name_entry;
  GtkWidget *code_entry;
  GtkWidget *dialog_action_area1;
  GtkWidget *cancelbutton1;
  GtkWidget *okbutton1;

  unlock_dialog = gtk_dialog_new_with_buttons(_("Unlock gtk2edit"),
                                              NULL,
                                              GTK_DIALOG_MODAL|GTK_DIALOG_DESTROY_WITH_PARENT|GTK_DIALOG_NO_SEPARATOR,
#if defined(HAVE_GNOME) || defined(G_OS_WIN32)
                                              _("_Purchase")  , 1,
#endif
                                              GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL,
                                              GTK_STOCK_OK    , GTK_RESPONSE_OK,
                                              NULL);
  gtk_widget_set_name (unlock_dialog, "unlock_dialog");
  gtk_container_set_border_width (GTK_CONTAINER (unlock_dialog), 6);
  gtk_window_set_position (GTK_WINDOW (unlock_dialog), GTK_WIN_POS_CENTER);
  gtk_window_set_resizable (GTK_WINDOW (unlock_dialog), FALSE);
  gtk_dialog_set_default_response(GTK_DIALOG(unlock_dialog), GTK_RESPONSE_OK);

  dialog_vbox1 = GTK_DIALOG (unlock_dialog)->vbox;
  gtk_widget_show (dialog_vbox1);

  vbox1 = gtk_vbox_new (FALSE, 12);
  gtk_widget_show (vbox1);
  gtk_box_pack_start (GTK_BOX (dialog_vbox1), vbox1, TRUE, TRUE, 0);

  label3 = gtk_label_new (_("<b>Enter the name and registration code</b>\nreceived when you've <i>purchased</i> this program.\n<span color=\"#006600\">(See <span color=\"red\">http://ex-code.com/gtk2edit/</span>\nfor ordering information.)</span>\n\n<small>They must be entered <b>exactly</b> as at the time of purchase!</small>"));
  gtk_widget_show (label3);
  gtk_box_pack_start (GTK_BOX (vbox1), label3, FALSE, FALSE, 0);
  /*GTK_WIDGET_SET_FLAGS (label3, GTK_CAN_FOCUS);*/
  gtk_label_set_use_markup (GTK_LABEL (label3), TRUE);
  /*gtk_label_set_justify (GTK_LABEL (label3), GTK_JUSTIFY_LEFT);*/
  gtk_label_set_selectable (GTK_LABEL (label3), TRUE);

  table1 = gtk_table_new (2, 2, FALSE);
  gtk_widget_show (table1);
  gtk_box_pack_start (GTK_BOX (vbox1), table1, TRUE, TRUE, 0);
  gtk_table_set_row_spacings (GTK_TABLE (table1), 6);
  gtk_table_set_col_spacings (GTK_TABLE (table1), 6);

  label1 = gtk_label_new_with_mnemonic (_("Full name:"));
  gtk_widget_show (label1);
  gtk_table_attach (GTK_TABLE (table1), label1, 0, 1, 0, 1,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (label1), 0, 0.5);

  label2 = gtk_label_new_with_mnemonic (_("Reg. code:"));
  gtk_widget_show (label2);
  gtk_table_attach (GTK_TABLE (table1), label2, 0, 1, 1, 2,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (label2), 0, 0.5);

  name_entry = gtk_entry_new ();
  gtk_widget_set_name (name_entry, "name_entry");
  gtk_widget_show (name_entry);
  gtk_table_attach (GTK_TABLE (table1), name_entry, 1, 2, 0, 1,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_entry_set_activates_default (GTK_ENTRY (name_entry), TRUE);

  code_entry = gtk_entry_new ();
  gtk_widget_set_name (code_entry, "code_entry");
  gtk_widget_show (code_entry);
  gtk_table_attach (GTK_TABLE (table1), code_entry, 1, 2, 1, 2,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_entry_set_max_length (GTK_ENTRY (code_entry), 10);
  gtk_entry_set_activates_default (GTK_ENTRY (code_entry), TRUE);

  dialog_action_area1 = GTK_DIALOG (unlock_dialog)->action_area;
  gtk_widget_show (dialog_action_area1);
  gtk_button_box_set_layout (GTK_BUTTON_BOX (dialog_action_area1), GTK_BUTTONBOX_END);

  g_signal_connect ((gpointer) unlock_dialog, "response",
                    G_CALLBACK (on_unlock_dialog_response),
                    NULL);

  gtk_label_set_mnemonic_widget (GTK_LABEL (label1), name_entry);
  gtk_label_set_mnemonic_widget (GTK_LABEL (label2), code_entry);

  GLADE_HOOKUP_OBJECT (unlock_dialog, name_entry, "name_entry");
  GLADE_HOOKUP_OBJECT (unlock_dialog, code_entry, "code_entry");

  return unlock_dialog;
}
