/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef UNDO_H_
#define UNDO_H_

#include <gtk/gtk.h>


#define TYPE_TEXT_UNDO_DATA  (text_undo_data_get_type())
#define TEXT_UNDO_DATA(obj) \
    (G_TYPE_CHECK_INSTANCE_CAST((obj), TYPE_TEXT_UNDO_DATA, TextUndoData))
#define TEXT_UNDO_DATA_CLASS(klass) \
    (G_TYPE_CHECK_CLASS_CAST((klass), TYPE_TEXT_UNDO_DATA, TextUndoDataClass))
#define IS_TEXT_UNDO_DATA(obj) \
    (G_TYPE_CHECK_INSTANCE_TYPE((obj), TYPE_TEXT_UNDO_DATA))
#define IS_TEXT_UNDO_DATA_CLASS(klass) \
    (G_TYPE_CHECK_CLASS_TYPE((klass), TYPE_TEXT_UNDO_DATA))
#define TEXT_UNDO_DATA_GET_CLASS(obj) \
    (G_TYPE_INSTANCE_GET_CLASS((obj), TYPE_TEXT_UNDO_DATA, TextUndoDataClass))

struct TextUndoData_;
typedef struct TextUndoData_ TextUndoData;

struct TextUndoDataClass_;
typedef struct TextUndoDataClass_ TextUndoDataClass;

GtkType    text_undo_data_get_type(void);

/* Attaches the undo data as "undo-data" user data to the buffer,
   undo data is destroyed with buffer. */
TextUndoData *text_undo_data_new(GtkTextBuffer *buffer);

void text_undo_data_clear(TextUndoData *text_undo_data);

gboolean text_undo_data_can_undo(TextUndoData *text_undo_data);
gboolean text_undo_data_can_redo(TextUndoData *text_undo_data);
void text_undo_data_undo(TextUndoData *text_undo_data);
void text_undo_data_redo(TextUndoData *text_undo_data);

TextUndoData *my_text_buffer_get_undo_data(GtkTextBuffer *buffer);

gboolean my_text_buffer_can_undo(GtkTextBuffer *buffer);
gboolean my_text_buffer_can_redo(GtkTextBuffer *buffer);
void my_text_buffer_undo(GtkTextBuffer *buffer);
void my_text_buffer_redo(GtkTextBuffer *buffer);

#endif /* UNDO_H_ */
