/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef INI_SETTINGS_H_
#define INI_SETTINGS_H_

/* Note: INI settings can work only with default GtkSettings
   (returned by gtk_settings_get_default()). Should be fixed. */

/* FIXME: Use GError for reporting errors. */

#include <glib-2.0/glib.h>
#include <glib-2.0/glib-object.h>

#include "iniparser/iniparser.h"

typedef void (*IniSettingsFileErrorCallback)(int err, gpointer user_data);

typedef struct IniSettingsFile_ {
    char *file_name;
    dictionary *dict;
    guint freeze_write_count, freeze_load_count;
    gboolean loading :1;
    GHashTable *keys_table, *sects_table;
    IniSettingsFileErrorCallback error_callback;
    gpointer user_data;
} IniSettingsFile;

IniSettingsFile *ini_settings_new(const char                   *file_name,
                                  IniSettingsFileErrorCallback  error_callback,
                                  gpointer                      user_data);

void ini_settings_destroy(IniSettingsFile *ini_file);

void ini_settings_install_property(IniSettingsFile *ini_file, GParamSpec *pspec);

void ini_settings_load (IniSettingsFile *ini_file);
void ini_settings_write(IniSettingsFile *ini_file);

/* Cumulative */
void ini_settings_freeze_write       (IniSettingsFile *ini_file);
void ini_settings_thaw_write         (IniSettingsFile *ini_file);
void ini_settings_thaw_write_no_write(IniSettingsFile *ini_file);
void ini_settings_freeze_load        (IniSettingsFile *ini_file);
void ini_settings_freeze_load_no_load(IniSettingsFile *ini_file);
void ini_settings_thaw_load          (IniSettingsFile *ini_file);

#endif /* INI_SETTINGS_H_ */
