#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gtk/gtk.h>
#include <gdk/gdkkeysyms.h> /* TODO: Move to an other file. */

#include "glade_callbacks.h"
#include "glade_interface.h"
#include "glade_support.h"

#include "iniparser/iniparser.h"
#include "main.h"
#include "mainwin.h"
#include "search.h"
#include "textundo.h"
#include "xmlstuff.h"
#include "prefs.h" /* dependency should be removed */
#include "prefsdlg.h"
#ifdef LIMITED_VERSION
#  include "unlock.h"
#endif /* LIMITED_VERSION */

void
on_mainwin_destroy                     (GtkObject       *object,
                                        gpointer         user_data)
{
    mainwin_destroy(mainwin_get_data(GTK_WIDGET(object)));
}


gboolean
on_mainwin_delete_event                (GtkWidget       *widget,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{
    const MainwinData *win_data;

    win_data = mainwin_get_data(widget);
    return !file_document_check_save(win_data->file_document);
}


gboolean
on_coord_label_box_button_press_event  (GtkWidget       *widget,
                                        GdkEventButton  *event,
                                        gpointer         user_data)
{
    const MainwinData *win_data;

    win_data = mainwin_get_data_by_widget(widget);
    if(event->type == GDK_BUTTON_PRESS && event->button == 1) {
        mainwin_goto_line_dialog(win_data);
        return TRUE;
    }
    return FALSE;
}


gboolean
on_encoding_label_box_button_press_event
                                       (GtkWidget       *widget,
                                        GdkEventButton  *event,
                                        gpointer         user_data)
{
    MainwinData *win_data;

    win_data = mainwin_get_data_by_widget(widget);
    if(event->type == GDK_BUTTON_PRESS && event->button == 1) {
        mainwin_ask_encoding(win_data);
        return TRUE;
    }
    return FALSE;
}


void
on_title_label_box_size_allocate       (GtkWidget       *widget,
                                        GdkRectangle    *allocation,
                                        gpointer         user_data)
{
    GtkAdjustment *adj;
    GtkRequisition label_requisition;
    int offset;
    MainwinData *win_data;

    win_data = mainwin_get_data_by_widget(widget);
    adj = gtk_layout_get_hadjustment(GTK_LAYOUT(widget));
    gtk_widget_size_request(win_data->title_label, &label_requisition);
    offset = MAX(0, label_requisition.width - allocation->width);
    gtk_adjustment_set_value(adj, offset);
    if(offset) {
        gtk_widget_map(win_data->title_ellipses);
        gtk_tooltips_enable(GTK_TOOLTIPS(file_tips));
    } else {
        gtk_widget_unmap(win_data->title_ellipses);
        gtk_tooltips_disable(GTK_TOOLTIPS(file_tips));
    }
}


gboolean
on_text_key_press_event                (GtkWidget       *widget,
                                        GdkEventKey     *event,
                                        gpointer         user_data)
{
    const MainwinData *win_data;

    win_data = mainwin_get_data_by_widget(widget);
    if((event->state&(GDK_CONTROL_MASK|GDK_SHIFT_MASK)) == GDK_CONTROL_MASK)
        switch(event->keyval) {
            case GDK_Up:
                my_text_view_scroll_lines(win_data, -1.0);
                return TRUE;
            case GDK_Down:
                my_text_view_scroll_lines(win_data, 1.0);
                return TRUE;
        }
    return FALSE;
}


void
on_new_file                            (GtkWidget       *widget,
                                        gpointer         user_data)
{
    const MainwinData *win_data;
    gpointer format;

    win_data = mainwin_get_data_by_widget(GTK_WIDGET(widget));
    format = file_document_get_format_copy(win_data->file_document);
    file_document_new_file(win_data->file_document, &format);
    file_document_format_destroy(win_data->file_document, format);
}


void
on_open_file                           (GtkWidget       *widget,
                                        gpointer         user_data)
{
    const MainwinData *win_data;
    gpointer format;
    guint format_value;

    win_data = mainwin_get_data_by_widget(GTK_WIDGET(widget));
    g_object_get(G_OBJECT(gtk_settings_get_default()),
                 N_("always-ask-encoding"), &format_value,
                 NULL);
    format = format_value >= 2 ? NULL
                               : file_document_get_format_copy(win_data->file_document);
    file_document_open(win_data->file_document, &format);
    file_document_format_destroy(win_data->file_document, format);
}


void
on_save_file                           (GtkWidget       *widget,
                                        gpointer         user_data)
{
    const MainwinData *win_data;

    win_data = mainwin_get_data_by_widget(GTK_WIDGET(widget));
    file_document_save(win_data->file_document);
}


void
on_save_file_as                        (GtkWidget       *widget,
                                        gpointer         user_data)
{
    const MainwinData *win_data;

    win_data = mainwin_get_data_by_widget(GTK_WIDGET(widget));
    file_document_save_as(win_data->file_document,
                          file_document_get_format(win_data->file_document));
}


void
on_insert_file                         (GtkWidget       *widget,
                                        gpointer         user_data)
{
    mainwin_insert_file_at_cursor_dialog(mainwin_get_data_by_widget(widget));
}


void
on_set_encoding                        (GtkWidget       *widget,
                                        gpointer         user_data)
{
    mainwin_ask_encoding(mainwin_get_data_by_widget(widget));
}


void
on_copy                                (GtkWidget       *widget,
                                        gpointer         user_data)
{
    const MainwinData *win_data;

    win_data = mainwin_get_data_by_widget(GTK_WIDGET(widget));
    g_signal_emit_by_name(win_data->thetext, N_("copy-clipboard"));
}


void
on_cut                                 (GtkWidget       *widget,
                                        gpointer         user_data)
{
    const MainwinData *win_data;

    win_data = mainwin_get_data_by_widget(GTK_WIDGET(widget));
    g_signal_emit_by_name(win_data->thetext, N_("cut-clipboard"));
}


void
on_paste                               (GtkWidget       *widget,
                                        gpointer         user_data)
{
    const MainwinData *win_data;

    win_data = mainwin_get_data_by_widget(widget);
    g_signal_emit_by_name(win_data->thetext, N_("paste-clipboard"));
}


void
on_undo                                (GtkWidget       *widget,
                                        gpointer         user_data)
{
    const MainwinData *win_data;

    win_data = mainwin_get_data_by_widget(widget);
    my_text_buffer_undo(win_data->thebuffer);
}


void
on_redo                                (GtkWidget       *widget,
                                        gpointer         user_data)
{
    const MainwinData *win_data;

    win_data = mainwin_get_data_by_widget(widget);
    my_text_buffer_redo(win_data->thebuffer);
}


void
on_make_uppercase                      (GtkWidget       *widget,
                                        gpointer         user_data)
{
    const MainwinData *win_data;

    win_data = mainwin_get_data_by_widget(widget);
    my_text_view_upper_or_lower_case(win_data->thebuffer, TRUE);
}


void
on_make_lowercase                      (GtkWidget       *widget,
                                        gpointer         user_data)
{
    const MainwinData *win_data;

    win_data = mainwin_get_data_by_widget(widget);
    my_text_view_upper_or_lower_case(win_data->thebuffer, FALSE);
}


void
on_close_xml_tag                       (GtkWidget       *widget,
                                        gpointer         user_data)
{
    const MainwinData *win_data;

    win_data = mainwin_get_data_by_widget(widget);
    close_xml_tag(win_data->thebuffer, win_data->thetext);
}


void
on_find                                (GtkWidget       *widget,
                                        gpointer         user_data)
{
    MainwinData *win_data;

    win_data = mainwin_get_data_by_widget(widget);
    call_find_dialog(&win_data->search_data);
}


void
on_find_next                           (GtkWidget       *widget,
                                        gpointer         user_data)
{
    MainwinData *win_data;

    win_data = mainwin_get_data_by_widget(widget);
    find_next(&win_data->search_data);
}


void
on_replace                             (GtkWidget       *widget,
                                        gpointer         user_data)
{
    MainwinData *win_data;

    win_data = mainwin_get_data_by_widget(widget);
    call_replace_dialog(&win_data->search_data);
}


void
on_goto_line                           (GtkWidget       *widget,
                                        gpointer         user_data)
{
    mainwin_goto_line_dialog(mainwin_get_data_by_widget(widget));
}


void
on_font                                (GtkWidget       *widget,
                                        gpointer         user_data)
{
    call_text_font_dialog(my_gtk_widget_get_toplevel(widget));
}


void
on_preferences                         (GtkWidget       *widget,
                                        gpointer         user_data)
{
    call_preferences_dialog(my_gtk_widget_get_toplevel(widget));
}


void
on_about                               (GtkWidget       *widget,
                                        gpointer         user_data)
{
    about_box(my_gtk_widget_get_toplevel(widget));
}


void
replace_dlg_on_replace_btn             (GtkButton       *button,
                                        gpointer         user_data)
{
    GtkWidget *window, *mainwin;
    MainwinData *win_data;

    window = gtk_widget_get_toplevel(GTK_WIDGET(button));
    mainwin = GTK_WIDGET(gtk_window_get_transient_for(GTK_WINDOW(window)));
    win_data = mainwin_get_data(mainwin);
    accomplish_replace(&win_data->search_data);
}


void
replace_dlg_on_replace_all_btn         (GtkButton       *button,
                                        gpointer         user_data)
{
    GtkWidget *window, *mainwin;
    MainwinData *win_data;

    window = gtk_widget_get_toplevel(GTK_WIDGET(button));
    mainwin = GTK_WIDGET(gtk_window_get_transient_for(GTK_WINDOW(window)));
    win_data = mainwin_get_data(mainwin);
    accomplish_replace_all(&win_data->search_data, FALSE);
}


void
replace_dlg_on_replace_in_selection_btn
                                        (GtkButton       *button,
                                        gpointer         user_data)
{
    GtkWidget *window, *mainwin;
    MainwinData *win_data;

    window = gtk_widget_get_toplevel(GTK_WIDGET(button));
    mainwin = GTK_WIDGET(gtk_window_get_transient_for(GTK_WINDOW(window)));
    win_data = mainwin_get_data(mainwin);
    accomplish_replace_all(&win_data->search_data, TRUE);
}


void
replace_dlg_on_find_btn                (GtkButton       *button,
                                        gpointer         user_data)
{
    GtkWidget *window, *mainwin;
    MainwinData *win_data;

    window = gtk_widget_get_toplevel(GTK_WIDGET(button));
    mainwin = GTK_WIDGET(gtk_window_get_transient_for(GTK_WINDOW(window)));
    win_data = mainwin_get_data(mainwin);
    accomplish_find(&win_data->search_data);
}


void
replace_dlg_on_close                   (GtkWidget       *widget,
                                        gpointer         user_data)
{
    gtk_widget_hide(my_gtk_widget_get_toplevel(widget));
}


void
on_revert_file_activate                (GtkWidget       *widget,
                                        gpointer         user_data)
{
    const MainwinData *win_data;

    win_data = mainwin_get_data_by_widget(widget);
    file_document_revert(win_data->file_document);
}


void
on_mainwin_close                       (GtkWidget       *widget,
                                        gpointer         user_data)
{
    const MainwinData *win_data;

    win_data = mainwin_get_data_by_widget(widget);
    if( file_document_check_save(win_data->file_document) )
        gtk_widget_destroy(win_data->mainwin);
}

void
on_unlock_activate                     (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
#ifdef LIMITED_VERSION
    const MainwinData *win_data;
    GtkWidget *dialog;

    win_data = mainwin_get_data_by_widget(GTK_WIDGET(menuitem));
    dialog = create_unlock_dialog();
    gtk_window_set_transient_for(GTK_WINDOW(dialog), GTK_WINDOW(win_data->mainwin));
    gtk_widget_show(dialog);
    /*gtk_dialog_run(GTK_DIALOG(dialog));*/
#endif /* LIMITED_VERSION */
}


void
on_help_menu                           (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
#ifdef LIMITED_VERSION
    const MainwinData *win_data;

    win_data = mainwin_get_data_by_widget(GTK_WIDGET(menuitem));
    (is_registered_version() ? gtk_widget_hide : gtk_widget_show)
        (GTK_WIDGET(win_data->unlock_menu_item));
#endif /* LIMITED_VERSION */
}

void
on_ask_encoding_toggled                (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
    const char *name;
    guint value;
    
    if(gtk_toggle_button_get_active(togglebutton)) {
        name = gtk_widget_get_name(GTK_WIDGET(togglebutton));
        value = (guint)(name[strlen(name)-1] - '0');
        g_object_set(gtk_settings_get_default(),
                     N_("always-ask-encoding"), value,
                     NULL);
    }
}

void
on_new_window_item_activate            (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
    mainwin_new();
}
