#!/bin/busybox ash
# (c) Robert Shingledecker 2010
# Called from desktop.sh to update wbar icons.

writeWBARitem() {
busybox awk -v output="$TMP" -v target="$TARGET" -v wbaricons="$TCEWBAR" '
BEGIN {
  FS = "="
  name = ""
  exec = ""
}
function rtrim(s) { sub(/[ \t]+$/, "", s); return s }
{
  if ( $1 == "Name" && name == "") {
    name = rtrim($2)
    gsub(/ /, "", name)
  } else if ( $1 == "Exec" && exec == "") {
    exec = $2
    test = match(exec,"%")
    if ( test ) exec = substr(exec,0,test-1)
  } else if ( $1 == "X-FullPathIcon" ) {
    icon = $2
  } else if ( $1 == "Terminal" ) {
    terminal = $2
  }
}
END {
  found = 0
  while (( getline item < wbaricons ) > 0 )
  {
    if ( index(item, target) > 0 )
    {
      found = 1
      print "i: " icon >> output
      print "t: " name > output
      if ( terminal == "true" ) {
	print "c: exec aterm +tr +sb -T \""name"\" -e " exec > output
      } else {
	print "c: exec " exec > output
      }
      getline item < wbaricons
      getline item < wbaricons
    } else {
      print item > output
    }
  }
  if ( found == 0 )
  {
  print "i: " icon >> output
  print "t: " name > output
  if ( terminal == "true" ) {
     print "c: exec aterm +tr +sb -T \""name"\" -e " exec > output
  } else {
    print "c: exec " exec > output
  }

  }
  close(wbaricons)
} ' "$1"
sudo mv "$TMP" "$TCEWBAR"
sudo chmod g+w "$TCEWBAR"
}

TCEWBAR="/usr/local/tce.icons"
TCEDIR=/etc/sysconfig/tcedir
APPNAME="$1"
#OnDemand xwbar check
if grep -qw "^t: *${APPNAME}$" "${TCEDIR}"/xwbar.lst 2>/dev/null; then exit 0; fi
TMP=/tmp/wbar.$$

#
FREEDESK=/usr/local/share/applications/"$APPNAME".desktop
if [ -e "$FREEDESK" ]; then
   ICONCHECK="$(awk 'BEGIN{FS = "="}$1=="X-FullPathIcon"{print $2}' "$FREEDESK")"
   NAMECHECK="$(awk 'BEGIN{FS = "="}$1=="Name"{print $2; exit 0}' "$FREEDESK")"
   if grep -qw "^t: *${NAMECHECK// /}$" "${TCEDIR}"/xwbar.lst 2>/dev/null; then exit 0; fi
   TARGET="$APPNAME".img
   [ -f "$ICONCHECK" ] && writeWBARitem "$FREEDESK" 
   exit 0
fi

#
FREEDESK=/usr/share/applications/"$APPNAME".desktop
if [ -e "$FREEDESK" ]; then
   ICONCHECK="$(awk 'BEGIN{FS = "="}$1=="Icon"{print $2}' "$FREEDESK")"
   echo "$ICONCHECK" > /tmp/.$$file
   ICONCHECK=/usr/share/pixmaps/"$ICONCHECK"
   if [ "${ICONCHECK##*.}" == "$ICONCHECK" ]; then
	if [ -f "$ICONCHECK".png ]; then
       	   ICONCHECK="$ICONCHECK".png
	elif [ -f "$ICONCHECK"*32*.png ]; then
	   ICONCHECK=`ls "$ICONCHECK"*32*.png`
	fi
	if [ -f "$ICONCHECK".xpm ]; then
       	   ICONCHECK="$ICONCHECK".xpm
	elif [ -f "$ICONCHECK"*32*.xpm ]; then
	   ICONCHECK=`ls "$ICONCHECK"*32*.xpm`
	fi
   else
         ICONCHECK="$(awk 'BEGIN{FS = "="}$1=="Icon"{print $2}' "$FREEDESK")"
	 if [ -f "$ICONCHECK" ] && ! echo "$ICONCHECK" | grep ".svg" > /dev/null 2>&1; then
	    ICONCHECK="$ICONCHECK"
         elif [ -f "$ICONCHECK"*32* ] && ! echo "$ICONCHECK" | grep ".svg" > /dev/null 2>&1; then
	    ICONCHECK=`ls "$ICONCHECK"*32*`
	 fi
   fi
   #NAMECHECK="$(awk 'BEGIN{FS = "="}$1=="Name"{print $2; exit 0}' "$FREEDESK")"
#   NAMECHECK="${NAMECHECK//[[:space:]]/}"
   NAMECHECK="$APPNAME"
   if grep -qw "^t: *${NAMECHECK// /}$" "${TCEDIR}"/xwbar.lst 2>/dev/null; then exit 0; fi
   if grep -qw "^t: *${NAMECHECK// /}$" "${HOME}"/.wbar 2>/dev/null; then exit 0; fi
   EXECCHECK="$(awk 'BEGIN{FS = "="}$1=="Exec"{print $2}' "$FREEDESK")"
   EXECCHECK="${EXECCHECK%\%*}"
   [ -f "$ICONCHECK" ] || exit 1
   echo "i: $ICONCHECK" >> "$TCEWBAR"
   echo "t: $NAMECHECK" >> "$TCEWBAR"
   echo "c: $EXECCHECK" >> "$TCEWBAR"
fi
