/****************************************************************************
 *  (c) Copyright 2007 Wi-Fi Alliance.  All Rights Reserved
 *
 *
 *  LICENSE
 *
 * License is granted only to Wi-Fi Alliance members and designated
 * contractors ($B!H(BAuthorized Licensees$B!I(B)..AN  Authorized Licensees are granted
 * the non-exclusive, worldwide, limited right to use, copy, import, export
 * and distribute this software:
 * (i) solely for noncommercial applications and solely for testing Wi-Fi
 * equipment; and
 * (ii) solely for the purpose of embedding the software into Authorized
 * Licensee$B!G(Bs proprietary equipment and software products for distribution to
 * its customers under a license with at least the same restrictions as
 * contained in this License, including, without limitation, the disclaimer of
 * warranty and limitation of liability, below..AN  The distribution rights
 * granted in clause (ii), above, include distribution to third party
 * companies who will redistribute the Authorized Licensee$B!G(Bs product to their
 * customers with or without such third party$B!G(Bs private label. Other than
 * expressly granted herein, this License is not transferable or sublicensable,
 * and it does not extend to and may not be used with non-Wi-Fi applications..AN 
 * Wi-Fi Alliance reserves all rights not expressly granted herein..AN 
 *
 * Except as specifically set forth above, commercial derivative works of
 * this software or applications that use the Wi-Fi scripts generated by this
 * software are NOT AUTHORIZED without specific prior written permission from
 * Wi-Fi Alliance..AN Non-Commercial derivative works of this software for
 * internal use are authorized and are limited by the same restrictions;
 * provided, however, that the Authorized Licensee shall provide Wi-Fi Alliance
 * with a copy of such derivative works under a perpetual, payment-free license
 * to use, modify, and distribute such derivative works for purposes of testing
 * Wi-Fi equipment.
 * Neither the name of the author nor "Wi-Fi Alliance" may be used to endorse
 * or promote products that are derived from or that use this software without
 * specific prior written permission from Wi-Fi Alliance.
 *
 * THIS SOFTWARE IS PROVIDED BY WI-FI ALLIANCE "AS IS" AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY, NON-INFRINGEMENT AND FITNESS FOR A.AN PARTICULAR PURPOSE,
 * ARE DISCLAIMED. IN NO EVENT SHALL WI-FI ALLIANCE BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, THE COST OF PROCUREMENT OF SUBSTITUTE
 * GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE) ARISING IN ANY WAY OUT OF
 * THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * ****************************************************************************
 *
 *  Revision History:
 *       2007/10/10 --  02.20 Voice SOHO beta -- qhu
 *       2007/11/07 --  02.30 Voice HSO -- qhu
 *
 */

#include <stdio.h>
#include <stdlib.h>
#ifndef WIN32
#include <pthread.h>
#include <time.h>
#endif
#include "wfa_debug.h"
#include "wfa_main.h"
#include "wfa_types.h"
#include "wfa_sock.h"
#include "wfa_tg.h"
#include "wfa_miscs.h"

extern tgStream_t *gStreams;
extern tgE2EStats_t *e2eStats;
extern int adj_latency;           /* adjust sleep time due to latency */
extern int        gagtSockfd;
#ifdef WFA_WMM_EXT
extern tgWMM_t wmm_thr[];
extern void *wfa_wmm_thread(void *thr_param);
extern void init_thr_flag();
extern int wfa_estimate_timer_latency();
#endif /* WFA_WMM_EXT */

#define LOCAL_PORT 11000

void wfa_dut_init(BYTE **tBuf, BYTE **rBuf, BYTE **paBuf, BYTE **cBuf, struct timeval **timerp)
{
    /* allocate the traffic stream table */
    gStreams = (tgStream_t *) malloc(WFA_MAX_TRAFFIC_STREAMS*sizeof(tgStream_t));
    if(gStreams == NULL)
    {
        DPRINT_ERR(WFA_ERR, "Failed to malloc theStreams\n");
        exit(1);
    }

    /* a buffer used to carry receive and send test traffic */
    *tBuf = (BYTE *) malloc(MAX_UDP_LEN+1); /* alloc a traffic buffer */
    if(*tBuf == NULL)
    {
        DPRINT_ERR(WFA_ERR, "Failed to malloc traffic buffer\n");
        exit(1);
    }

    /* a buffer used for response of control command */
    *rBuf = (BYTE *)malloc(WFA_BUFF_512);
    if(*rBuf == NULL)
    {
        DPRINT_ERR(WFA_ERR, "Failed to malloc response buffer\n");
        exit(1);
    }

    /* timer used in select call */
    *timerp = malloc(sizeof(struct timeval));
    if(*timerp == NULL)
    {
        DPRINT_ERR(WFA_ERR, "Failed to malloc timer val\n");
        exit(1);
    }

    /* control command buf */
    *cBuf = malloc(WFA_BUFF_1K);
    if(*cBuf == NULL)
    {
        DPRINT_ERR(WFA_ERR, "Failed to malloc control command buf\n");
        exit(1);
    }

    /* parameters buff */
    *paBuf = malloc(MAX_PARMS_BUFF);
    if(*paBuf == NULL)
    {
        DPRINT_ERR(WFA_ERR, "Failed to malloc parms value buff\n");
        exit(1);
    }
#ifndef WIN32
#ifdef WFA_WMM_EXT
    /* allocate for End2End stats */
    init_thr_flag();
#endif /* WFA_WMM_EXT   */
#endif /* WIN32 */

	e2eStats = malloc(6144*sizeof(tgE2EStats_t));
    if(e2eStats == NULL)
    {
       DPRINT_ERR(WFA_ERR, "Failed to malloc e2eStats\n");
       exit(1);
    }


#ifdef WIN32
	adj_latency = wfa_Win_estimate_timer_latency() + 4000; /* four more mini */
#else    
	adj_latency = wfa_estimate_timer_latency() + 4000; /* four more mini */
#endif

    /* 4create listening TCP socket */
    gagtSockfd = wfaCreateTCPServSock(LOCAL_PORT);

	if(gagtSockfd == -1)
    {
       DPRINT_ERR(WFA_ERR, "Failed to open socket\n");
       exit(1);
    }
}
