#!/usr/bin/env python
# sugar-lint: disable

import time

import gobject

from __init__ import tests

from sugar_stats.collector import Collector


class CollectorTest(tests.Test):

    def test_tick(self):
        backend = Backend()
        stats = Collector([], backend)
        stats.start()

        stats.update('activity.uptime', True)
        stats.update('activity.active', True)
        stats.update('activity.instances', 1)
        stats.update('activity.new', 2)
        stats.update('activity.resumed', 3)
        stats.update('activity.buddies', 4)

        stats._tick()
        self.assertEqual(0, backend.updates['activity']['uptime'])
        self.assertEqual(0, backend.updates['activity']['active'])
        self.assertEqual(1, backend.updates['activity']['instances'])
        self.assertEqual(2, backend.updates['activity']['new'])
        self.assertEqual(3, backend.updates['activity']['resumed'])
        self.assertEqual(4, backend.updates['activity']['buddies'])

    def test_Absolute(self):
        backend = Backend()
        stats = Collector([], backend)
        stats.start()

        backend.updates.clear()
        stats.update('shell.friends', 0)
        stats._tick()
        self.assertEqual(0, backend.updates['shell']['friends'])

        backend.updates.clear()
        stats.update('shell.friends', 1)
        stats._tick()
        self.assertEqual(1, backend.updates['shell']['friends'])

        backend.updates.clear()
        stats._tick()
        self.assertEqual(1, backend.updates['shell']['friends'])

    def test_OneTickRegister(self):
        backend = Backend()
        stats = Collector([], backend)
        stats.start()

        backend.updates.clear()
        stats.update('journal.creates', 0)
        stats._tick()
        self.assertEqual(0, backend.updates['journal']['creates'])

        backend.updates.clear()
        stats.update('journal.creates', 1)
        stats.update('journal.creates', 1)
        stats._tick()
        self.assertEqual(2, backend.updates['journal']['creates'])

        backend.updates.clear()
        stats._tick()
        self.assertEqual(0, backend.updates['journal']['creates'])

        self.assertRaises(RuntimeError, stats.update, 'journal.creates', -1)

    def test_Register(self):
        backend = Backend()
        stats = Collector([], backend)
        stats.start()

        backend.updates.clear()
        stats.update('activity.instances', 0)
        stats._tick()
        self.assertEqual(0, backend.updates['activity']['instances'])

        backend.updates.clear()
        stats.update('activity.instances', 1)
        stats.update('activity.instances', 1)
        stats._tick()
        self.assertEqual(2, backend.updates['activity']['instances'])

        backend.updates.clear()
        stats._tick()
        self.assertEqual(2, backend.updates['activity']['instances'])

        backend.updates.clear()
        stats.update('activity.instances', -1)
        stats._tick()
        self.assertEqual(1, backend.updates['activity']['instances'])

        backend.updates.clear()
        stats._tick()
        self.assertEqual(1, backend.updates['activity']['instances'])

    def test_Uptime(self):
        backend = Backend()
        stats = Collector([], backend)
        stats.start()

        backend.updates.clear()
        stats.update('activity.uptime', False)
        stats._tick()
        self.assertEqual(0, backend.updates['activity']['uptime'])

        backend.updates.clear()
        stats.update('activity.uptime', True)
        time.sleep(1)
        stats._tick()
        self.assertEqual(1, backend.updates['activity']['uptime'])

        backend.updates.clear()
        time.sleep(1)
        stats.update('activity.uptime', False)
        stats._tick()
        self.assertEqual(2, backend.updates['activity']['uptime'])

        backend.updates.clear()
        stats._tick()
        self.assertEqual(0, backend.updates['activity']['uptime'])

        backend.updates.clear()
        stats.update('activity.uptime', True)
        time.sleep(1)
        stats.update('activity.uptime', False)
        time.sleep(2)
        stats.update('activity.uptime', True)
        time.sleep(1)
        stats.update('activity.uptime', False)
        stats._tick()
        self.assertEqual(2, backend.updates['activity']['uptime'])

        backend.updates.clear()
        stats._tick()
        self.assertEqual(0, backend.updates['activity']['uptime'])

    def test_tick_Instance(self):
        backend = Backend()
        stats = Collector([], backend)
        stats.start()

        stats.update('activity.instances', 1, 'foo')
        stats._tick()
        self.assertEqual(1, backend.updates['activity.foo']['instances'])

    def test_tick_Timeout(self):
        backend = Backend()
        stats = Collector([], backend)
        stats.start()
        mainloop = gobject.MainLoop()

        stats.update('activity.instances', 1)
        gobject.timeout_add_seconds(1, lambda: mainloop.quit())
        mainloop.run()
        self.assertEqual(1, backend.updates['activity']['instances'])

        stats.update('activity.instances', 2)
        gobject.timeout_add_seconds(1, lambda: mainloop.quit())
        mainloop.run()
        self.assertEqual(3, backend.updates['activity']['instances'])


class Backend(object):

    step = 1

    def __init__(self):
        self.updates = {}

    def put(self, name, values):
        self.updates[name] = values


if __name__ == '__main__':
    tests.main()
