# -*- coding: utf-8 -*-
# Copyright (C) 2012, Sebastian Silva
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

from flask import g,request,url_for
from flaskext.babel import gettext as _
import logging
from werkzeug.contrib.atom import AtomFeed

import datetime
from app import app

def timedelta(mtime):
    return datetime.datetime.fromtimestamp(mtime)

@app.route('/context.atom')
def context_feed():

    feed = AtomFeed(_('Recent Contexts'),
                    feed_url=request.url, url=request.url_root)

    g.feed_Contexts._reset()
    g.feed_Contexts.offset = -1
    i = 0
    for context in g.feed_Contexts:
        if i==15:
            break
        feed.add(context['title'], unicode(context.get('description')),
                 content_type='text',
                 author=context['author'],
                 url=url_for('project_browser', context_guid=context['guid']),
                 updated=timedelta(context['mtime']),
                 published=timedelta(context['ctime']))
        i = i+1

    return feed.get_response()

@app.route('/feedback.atom')
def feedback_feed():

    feed = AtomFeed(_('Recent Feedback'),
                    feed_url=request.url, url=request.url_root)

    g.feed_Resources._reset()
    g.feed_Resources.offset = -1
    i = 0
    for resource in g.feed_Resources:
        if i==15:
            break
        feed.add(resource['title'], unicode(resource.get('content')),
                 content_type='text',
                 author=resource['author'],
                 url=url_for('solution_browser',
                    resource_guid=resource['guid']),
                 categories=[{'term':resource['type'].pop()}],
                 updated=timedelta(resource['mtime']),
                 published=timedelta(resource['ctime']))
        i = i+1

    return feed.get_response()
