# -*- coding: utf-8 -*-
# Copyright (C) 2012, Sebastian Silva
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

import flask
from flask_classy import FlaskView
from flaskext.babel import gettext as _
import logging


class FeedbackView(FlaskView):

    def new(self):
        context_guid = flask.request.args.get('context') or \
                            flask.session.get('last_context') or \
                            'sugar-network'
        title = flask.request.args.get('title')
        return flask.render_template('dialog_resource.html',
                    title=title,
                    context=context_guid,
                    mode='new')

    def edit(self):
        context_guid = flask.request.args.get('context')
        title = flask.request.args.get('title')
        content = flask.request.args.get('content')
        resource = flask.request.args.get('resource')
        resource_type = flask.request.args.get('resource_type')
        return flask.render_template('dialog_resource.html',
                    context=context_guid,
                    title=title,
                    content=content,
                    resource=resource,
                    resource_type=resource_type,
                    mode='edit')


class ProjectView(FlaskView):

    def new(self):
        if flask.request.args.get('returnto'):
            flask.session['returnto'] = flask.request.args.get('returnto')
        return flask.render_template('dialog_project.html',
                    mode='new', **flask.request.args)

    def edit(self):
        if flask.request.args.get('returnto'):
            flask.session['returnto'] = flask.request.args.get('returnto')
        return flask.render_template('dialog_project.html',
                    mode='edit', **flask.request.args)


class AboutView(FlaskView):

    def index(self):
        if flask.request.args.get('returnto'):
            flask.session['returnto'] = flask.request.args.get('returnto')
        return flask.render_template('dialog_about.html')
