# -*- coding: utf-8 -*-
# Copyright (C) 2012, Sebastian Silva
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

from os.path import join
#import webbrowser
from sugar_network import toolkit, local
from sugar_network.toolkit import sugar
from sugar_network.local.mounts import HomeMount, RemoteMount
from sugar_network.local.mountset import Mountset
from sugar_network.resources.volume import Volume
#from flask_debugtoolbar import DebugToolbarExtension


def _mountset():
    toolkit.ensure_dsa_pubkey(sugar.profile_path('owner.key'))

    _db_path = join(local.local_root.value, 'local')
    volume = Volume(_db_path, lazy_open=local.lazy_open.value)
    mountset = Mountset(volume)
    mountset['~'] = HomeMount(volume)
    mountset['/'] = RemoteMount(volume)

    return mountset

mountset = _mountset()

import sugar_network_webui as webui

#from gevent.wsgi import WSGIServer

host = '0.0.0.0'  # '0.0.0.0' for all
port = 9500
#http_server = WSGIServer((host, 5000), webui.get_app(mountset))

#url = 'http://localhost:5000'
#webbrowser.open(url)

#http_server.serve_forever()

app = webui.get_app(mountset)
app.debug = True
#app.config['DEBUG_TB_INTERCEPT_REDIRECTS'] = False
#app.config['DEBUG_TB_TEMPLATE_EDITOR_ENABLED'] = True
#toolbar = DebugToolbarExtension(app)

app.run(host=host, port=port)
