# Copyright (C) 2012 Aleksey Lim
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.


class Sniffer(object):

    def start(self):
        """Activate sniffer."""
        pass

    def stop(self):
        """Disactivate sniffer."""
        pass

    def trigger(self):
        """Force sniffer to publish updates.

        If sniffers monitor changes on theirs own, there is no need
        in overriding this function. Otherwise, this function will be called
        out of sniffer code to let sniffer a chance to publish updates on
        regular basis.

        """
        pass

    def update(self, stat, value, instance=None):
        """Callback to call from sniffer to publish updates.

        There is no need in overriding this function, it will be set
        out of sniffer code.

        """
        pass

    def get_sniffer(self, name):
        """Callback to get one of active sniffers by name.

        There is no need in overriding this function, it will be set
        out of sniffer code.

        """
        pass
