# Copyright (C) 2012 Aleksey Lim
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

import socket

from sugar_stats.sniffer import Sniffer


# DNS name to check if host is in school network
_SCHOOL_DNS_NAME = 'am.i.at.school'


class Network(Sniffer):

    def start(self):
        pass

    def trigger(self):
        self.update('network.uptime', _is_online())
        self.update('network.school', _is_at_school())


def _is_at_school():
    try:
        __ = socket.getaddrinfo(_SCHOOL_DNS_NAME, 0)[0][4][0]
        return True
    except socket.gaierror:
        return False


def _is_online():
    with file('/proc/net/route') as route:
        for line in route.readlines():
            try:
                if int(line.split('\t')[1], 16) == 0:
                    return True
            except ValueError:
                pass
    return False
