# Copyright (C) 2012 Aleksey Lim
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

from gettext import dgettext


_ = lambda x: dgettext('sugar-plugin-telepathy', x)

ORDER = 10
TITLE = _('Alternative implementation of Neighborhood collaboration')

def init():
    from jarabe.model import neighborhood, buddy
    from .neighborhood import get_model as neighborhood_model
    from .buddy import get_owner_instance

    neighborhood.get_model = neighborhood_model
    buddy.get_owner_instance = get_owner_instance


def start():
    pass
