#!/usr/bin/env python

import logging
import gobject
from dbus.mainloop.glib import DBusGMainLoop

from sugar_stats import Rrd, Collector


logging.basicConfig(level=logging.DEBUG)
DBusGMainLoop(set_as_default=True)

backend = Rrd('tmp', 3, ['RRA:AVERAGE:0.5:1:360'])
collector = Collector(backend)
collector.start()

mainloop = gobject.MainLoop()
try:
    mainloop.run()
except KeyboardInterrupt:
    pass
finally:
    collector.stop()
