/*$
Copyright (C) 2013-2016 Azel.

This file is part of AzPainter.

AzPainter is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

AzPainter is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.
$*/
/*
    キャンバス関連ダイアログ
*/

#include "dialog_canvas.h"

#include "AXLayout.h"
#include "AXLabel.h"
#include "AXLineEdit.h"
#include "AXCheckButton.h"
#include "AXComboBox.h"
#include "AXApp.h"
#include "AXGroupBox.h"
#include "strid.h"



//***********************************************
// CResizeCanvasDlg : キャンバスサイズ変更ダイアログ
//***********************************************

enum
{
    STRID_RESIZECANV_TITLE,
    STRID_RESIZECANV_ALIGN
};


CResizeCanvasDlg::CResizeCanvasDlg(AXWindow *pOwner,int *pVal)
    : AXDialog(pOwner, WS_DIALOG_NORMAL | WS_BK_FACE)
{
    AXLayout *plTop,*pl,*pl2;
    int i;
    AXCheckButton *pck;

    m_pVal = pVal;

    //

    _trgroup(strid::GROUP_DLG_RESIZECANVAS);

    setTitle(STRID_RESIZECANV_TITLE);

    setLayout(plTop = new AXLayoutVert);
    plTop->setSpacing(10);

    //-----------

    plTop->addItem(pl = new AXLayoutMatrix(2));

    //幅

    pl->addItem(new AXLabel(this, 0, LF_RIGHT|LF_CENTER_Y, MAKE_DW4(0,0,10,8), _string(strid::GROUP_WORD, strid::WORD_WIDTH)));
    pl->addItem(m_peditW = new AXLineEdit(this, AXLineEdit::ES_SPIN, 0, 0, MAKE_DW4(0,0,0,8)));

    m_peditW->setInit(6, 1, 9999, pVal[0]);

    //高さ

    pl->addItem(new AXLabel(this, 0, LF_RIGHT|LF_CENTER_Y, MAKE_DW4(0,0,10,8), _string(strid::GROUP_WORD, strid::WORD_HEIGHT)));
    pl->addItem(m_peditH = new AXLineEdit(this, AXLineEdit::ES_SPIN, 0, 0, MAKE_DW4(0,0,0,8)));

    m_peditH->setInit(6, 1, 9999, pVal[1]);

    //配置

    pl->addItem(new AXLabel(this, 0, LF_RIGHT, MAKE_DW4(0,0,10,0), STRID_RESIZECANV_ALIGN));
    pl->addItem(pl2 = new AXLayoutMatrix(3));

    for(i = 0; i < 9; i++)
    {
        pl2->addItem(pck = new AXCheckButton(this,
                                AXCheckButton::CBS_BUTTON|AXCheckButton::CBS_RADIO|AXCheckButton::CBS_REALSIZE,
                                0, 0, 0, (LPCUSTR)NULL, (i == 0)));

        pck->setMinSize(30, 30);

        if(i == 0) m_pckAlign = pck;
    }

    //-------

    m_peditW->setFocus();
    m_peditW->selectAll();

    createOKCancelAndShow(15);
}

//! 通知

BOOL CResizeCanvasDlg::onNotify(AXWindow *pwin,UINT uNotify,ULONG lParam)
{
    switch(pwin->getItemID())
    {
        //OK
        case 1:
            m_pVal[0] = m_peditW->getVal();
            m_pVal[1] = m_peditH->getVal();
            m_pVal[2] = m_pckAlign->getGroupSel();

            endDialog(TRUE);
            break;
        //キャンセル
        case 2:
            endDialog(FALSE);
            break;
    }

    return TRUE;
}



//***********************************************
// CScaleCanvasDlg : キャンバス拡大縮小ダイアログ
//***********************************************

enum
{
    STRID_SC_TITLE,
    STRID_SC_SIZE,
    STRID_SC_PERS,
    STRID_SC_KEEPASPECT,
    STRID_SC_CHANGEDPI,
    STRID_SC_TYPE,
    STRID_SC_INFO
};

enum
{
    WID_EDIT_SIZEW = 100,
    WID_EDIT_SIZEH,
    WID_EDIT_PERSW,
    WID_EDIT_PERSH,
    WID_CK_CHANGEDPI,
    WID_EDIT_DPI
};


CScaleCanvasDlg::CScaleCanvasDlg(AXWindow *pOwner,VALUE *pVal)
    : AXDialog(pOwner, WS_DIALOG_NORMAL | WS_BK_FACE)
{
    AXLayout *plTop,*plh,*pl;
    AXWindow *pGB;

    m_pVal = pVal;

    m_nSize[0] = pVal->nWidth;
    m_nSize[1] = pVal->nHeight;
    m_nSize[2] = m_nSize[3] = 1000;

    //

    _trgroup(strid::GROUP_DLG_SCALECANVAS);

    setTitle(STRID_SC_TITLE);

    setLayout(plTop = new AXLayoutVert(0, 8));
    plTop->setSpacing(8);

    //------ サイズと%

    plTop->addItem(plh = new AXLayoutHorz(0, 8));

    //サイズ

    plh->addItem(pGB = new AXGroupBox(this, 0, 0, 0, _str(STRID_SC_SIZE)));

    pGB->setLayout(pl = new AXLayoutMatrix(2));
    pl->setSpacing(8);

    pl->addItem(new AXLabel(pGB, 0, LF_RIGHT|LF_CENTER_Y, MAKE_DW4(0,0,6,6), _string(strid::GROUP_WORD, strid::WORD_WIDTH)));
    pl->addItem(m_peditSize[0] = new AXLineEdit(pGB, AXLineEdit::ES_SPIN, 0, WID_EDIT_SIZEW, MAKE_DW4(0,0,0,6)));

    pl->addItem(new AXLabel(pGB, 0, LF_RIGHT|LF_CENTER_Y, MAKE_DW4(0,0,6,0), _string(strid::GROUP_WORD, strid::WORD_HEIGHT)));
    pl->addItem(m_peditSize[1] = new AXLineEdit(pGB, AXLineEdit::ES_SPIN, 0, WID_EDIT_SIZEH, 0));

    m_peditSize[0]->setInit(5, 1, 9999, pVal->nWidth);
    m_peditSize[1]->setInit(5, 1, 9999, pVal->nHeight);

    //%

    plh->addItem(pGB = new AXGroupBox(this, 0, 0, 0, _str(STRID_SC_PERS)));

    pGB->setLayout(pl = new AXLayoutMatrix(2));
    pl->setSpacing(8);

    pl->addItem(new AXLabel(pGB, 0, LF_RIGHT|LF_CENTER_Y, MAKE_DW4(0,0,6,6), _string(strid::GROUP_WORD, strid::WORD_WIDTH)));
    pl->addItem(m_peditSize[2] = new AXLineEdit(pGB, AXLineEdit::ES_SPIN, 0, WID_EDIT_PERSW, MAKE_DW4(0,0,0,6)));

    pl->addItem(new AXLabel(pGB, 0, LF_RIGHT|LF_CENTER_Y, MAKE_DW4(0,0,6,0), _string(strid::GROUP_WORD, strid::WORD_HEIGHT)));
    pl->addItem(m_peditSize[3] = new AXLineEdit(pGB, AXLineEdit::ES_SPIN, 0, WID_EDIT_PERSH, 0));

    m_peditSize[2]->setInit(6, 1, 20000, 1, 1000);
    m_peditSize[3]->setInit(6, 1, 20000, 1, 1000);

    //--------

    //縦横比維持

    plTop->addItem(m_pckAspect = new AXCheckButton(this, 0, LF_RIGHT, 0, 0, STRID_SC_KEEPASPECT, TRUE));

    //---------

    plTop->addItem(pl = new AXLayoutMatrix(2));

    //DPI変更

    pl->addItem(m_pckDPI = new AXCheckButton(this, 0, LF_CENTER_Y, WID_CK_CHANGEDPI, MAKE_DW4(0,0,8,6), STRID_SC_CHANGEDPI, FALSE));
    pl->addItem(m_peditDPI = new AXLineEdit(this, WS_DISABLE|AXLineEdit::ES_SPIN, LF_CENTER_Y, WID_EDIT_DPI, MAKE_DW4(0,0,0,6)));

    m_peditDPI->setInit(6, 1, 10000, pVal->nDPI);

    //補間方法

    pl->addItem(new AXLabel(this, 0, LF_RIGHT|LF_CENTER_Y, MAKE_DW4(0,0,8,0), STRID_SC_TYPE));
    pl->addItem(m_pcbType = new AXComboBox(this, 0, 0));

    //ヘルプ

    plTop->addItem(new AXLabel(this, AXLabel::LS_BORDER, LF_EXPAND_W, MAKE_DW4(0,12,0,0), STRID_SC_INFO));

    //------- 補間方法

    _trgroup(strid::GROUP_SCALETYPE);

    m_pcbType->addItemMulTr(0, 5);
    m_pcbType->setAutoWidth();
    m_pcbType->setCurSel(pVal->nType);

    //-------

    plTop->addItem(pl = createOKCancelButton());
    pl->setPaddingTop(6);

    //

    m_peditSize[0]->setFocus();
    m_peditSize[0]->selectAll();

    //

    calcDefSize();
    resize(m_nDefW, m_nDefH);

    show();
}

//! 通知

BOOL CScaleCanvasDlg::onNotify(AXWindow *pwin,UINT uNotify,ULONG lParam)
{
    UINT id = pwin->getItemID();

    switch(id)
    {
        //サイズ
        case WID_EDIT_SIZEW:
        case WID_EDIT_SIZEH:
        case WID_EDIT_PERSW:
        case WID_EDIT_PERSH:
            if(uNotify == AXLineEdit::EN_CHANGE)
                _changeVal(id - WID_EDIT_SIZEW);
            break;
        //DPI変更
        case WID_CK_CHANGEDPI:
            _setChangeDPI();
            break;
        //DPI値
        case WID_EDIT_DPI:
            _changeDPI();
            break;

        //OK
        case 1:
            m_pVal->nWidth  = m_peditSize[0]->getVal();
            m_pVal->nHeight = m_peditSize[1]->getVal();
            m_pVal->nDPI    = (m_pckDPI->isChecked())? m_peditDPI->getVal(): -1;
            m_pVal->nType   = m_pcbType->getCurSel();

            endDialog(1);
            break;
        //キャンセル
        case 2:
            endDialog(0);
            break;
    }

    return TRUE;
}


//======================


//! DPI変更チェック時

void CScaleCanvasDlg::_setChangeDPI()
{
    int f,i;

    f = !m_pckDPI->isChecked();

    for(i = 0; i < 4; i++)
        m_peditSize[i]->enable(f);

    m_peditDPI->enable(!f);

    if(!f) _changeDPI();
}

//! DPI値変更時

void CScaleCanvasDlg::_changeDPI()
{
    double scale;

    scale = (double)m_peditDPI->getVal() / m_pVal->nDPI;

    m_nSize[0] = (int)(m_pVal->nWidth * scale + 0.5);
    m_nSize[1] = (int)(m_pVal->nHeight * scale + 0.5);
    m_nSize[2] = m_nSize[3] = (int)(scale * 1000.0 + 0.5);

    _setVal(-1);
}

//! エディットに値セット
/*!
    @param type セットしない値
*/

void CScaleCanvasDlg::_setVal(int type)
{
    int i;

    for(i = 0; i < 4; i++)
    {
        if(type != i)
            m_peditSize[i]->setVal(m_nSize[i]);
    }
}

//! エディット値変更時

void CScaleCanvasDlg::_changeVal(int type)
{
    BOOL bKeep = m_pckAspect->isChecked();
    int n1,n2,w1,w2;

    if(type == 0 || type == 2)
        w1 = m_pVal->nWidth, w2 = m_pVal->nHeight;
    else
        w1 = m_pVal->nHeight, w2 = m_pVal->nWidth;

    //

    if(type < 2)
    {
        //px

        n1 = type;
        n2 = 1 - type;

        m_nSize[n1]     = m_peditSize[n1]->getVal();
        m_nSize[2 + n1] = (int)((double)m_nSize[n1] / w1 * 1000.0 + 0.5);

        if(bKeep)
        {
            m_nSize[n2]     = (int)((double)m_nSize[n1] / w1 * w2 + 0.5);
            m_nSize[2 + n2] = m_nSize[2 + n1];
        }
    }
    else
    {
        //%

        n1 = type;
        n2 = 5 - type;

        m_nSize[n1]     = m_peditSize[n1]->getVal();
        m_nSize[n1 - 2] = (int)((double)m_nSize[n1] / 1000.0 * w1 + 0.5);

        if(bKeep)
        {
            m_nSize[n2]     = m_nSize[n1];
            m_nSize[n2 - 2] = (int)((double)m_nSize[n2] / 1000.0 * w2 + 0.5);
        }
    }

    _setVal(type);
}
