/*$
Copyright (C) 2013-2016 Azel.

This file is part of AzPainter.

AzPainter is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

AzPainter is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.
$*/
/*
    CToolWin : ツールウィンドウ
*/


#include "CToolWin.h"

#include "CScaleRotBar.h"
#include "CConfig.h"
#include "CResource.h"

#include "drawdat.h"
#include "draw_main.h"

#include "global.h"
#include "strid.h"

#include "AXLayout.h"
#include "AXToolBar.h"




CToolWin *CToolWin::m_pSelf = NULL;


CToolWin::CToolWin(AXWindow *pOwner,UINT addstyle)
    : AXTopWindow(pOwner,
                  WS_HIDE | WS_BK_FACE | WS_TITLE | WS_CLOSE | WS_BORDER | WS_DISABLE_IM | WS_DISABLE_RESIZE | addstyle)
{
    AXLayout *pl;

    m_pSelf = this;

    //

    setFont(g_res->pfontSmall);

    setTitle("tool");

    attachAccel(((AXTopWindow *)m_pOwner)->getAccel());

    //

    setLayout(pl = new AXLayoutVert);

    pl->setSpacing(1);

    _createTB_tool();
    _createTB_sub();

    //表示倍率

    m_pwidScale = new CScaleRotBar(this, 0, MAKE_DW4(0,8,1,4), draw::SCALE_MIN, draw::SCALE_MAX);
    pl->addItem(m_pwidScale);

    m_pwidScale->setPos(g_draw->view.nScale);

    //回転

    pl->addItem(m_pwidRot = new CScaleRotBar(this, CScaleRotBar::STYLE_ROTATE, MAKE_DW4(0,0,1,0), 0, 0));

    //

    calcDefSize();
    resize(m_nDefW, m_nDefH);

    //

    _initTB_sub();

    changeTool();
}

//! 表示/非表示

void CToolWin::showToggle()
{
    if(g_conf->isToolWin())
        showRestore();
    else
        hide();
}

//! ツールバーチェック（ツール）

void CToolWin::checkTB_tool(int no)
{
    m_ptbTool->checkItem(CMDID_TOOL + no, TRUE);
}

//! ツールバーチェック（ブラシ/ドットの描画タイプ）

void CToolWin::checkTB_toolsub_pen(int no)
{
    m_ptbSub[TOOLSUB_DRAW]->checkItem(CMDID_TOOLSUB + no, TRUE);
}

//! 表示倍率変更時

void CToolWin::changeScale()
{
    m_pwidScale->setPos(g_draw->view.nScale);
}

//! 回転変更時

void CToolWin::changeRotate()
{
    m_pwidRot->setPos(g_draw->view.nAngle);
}

//! ツール変更時

void CToolWin::changeTool()
{
    int no,subno;
    AXToolBar *ptbNew;

    no = g_draw->tool.toolno;

    //--------- ツール

    m_ptbTool->checkItem(CMDID_TOOL + no, TRUE);

    //--------- サブタイプ

    switch(no)
    {
        case draw::TOOL_BRUSH:
        case draw::TOOL_DOTPEN:
            subno = TOOLSUB_DRAW;
            break;
        case draw::TOOL_POLYPAINT:
        case draw::TOOL_POLYERASE:
            subno = TOOLSUB_POLYGON;
            break;
        case draw::TOOL_GRAD:
            subno = TOOLSUB_GRAD;
            break;
        case draw::TOOL_SEL:
            subno = TOOLSUB_SEL;
            break;
        case draw::TOOL_BOXEDIT:
            subno = TOOLSUB_BOXEDIT;
            break;
        case draw::TOOL_SCALE:
            subno = TOOLSUB_SCALE;
            break;
        default:
            subno = -1;
            break;
    }

    ptbNew = (subno == -1)? NULL: m_ptbSub[subno];

    //変更

    if(ptbNew != m_ptbSubNow)
    {
        if(m_ptbSubNow)
            m_ptbSubNow->hide();

        m_ptbSubNow = ptbNew;
    }

    if(ptbNew)
    {
        ptbNew->checkItem(CMDID_TOOLSUB + g_draw->tool.toolSubNo[no], TRUE);
        ptbNew->show();
    }
}


//=========================
//初期化
//=========================


//! ツールバー作成：ツール

void CToolWin::_createTB_tool()
{
    int i;
    UINT f;

    m_ptbTool = new AXToolBar(this,
            AXToolBar::TBS_SEPBOTTOM|AXToolBar::TBS_TOOLTIP|AXToolBar::TBS_TOOLTIP_TR,
            0);

    m_ptbTool->setImageList(g_res->pilToolTB);
    m_ptbTool->setToolTipTrGroup(strid::GROUP_TOOL);

    getLayout()->addItem(m_ptbTool);

    //ボタン

    for(i = 0; i < draw::TOOL_NUM; i++)
    {
        f = AXToolBar::BF_CHECKGROUP;
        if(i == draw::TOOL_NUM/2 - 1) f |= AXToolBar::BF_WRAP;

        m_ptbTool->addItem(CMDID_TOOL + i, i, i, f, 0);
    }
}

//! ツールバー作成：サブタイプ

void CToolWin::_createTB_sub()
{
    UINT style;
    int type,i,imgno;
    LPBYTE ptbl;
    int bttcnt[TOOLSUB_NUM] = {
        draw::DRAWTYPE_NUM, 4, 4, 4, 5, 2
    };
    int tblimgno[TOOLSUB_NUM] = {
        0, draw::DRAWTYPE_NUM, draw::DRAWTYPE_NUM+5, -1, draw::DRAWTYPE_NUM+11, draw::DRAWTYPE_NUM+9
    };
    BYTE tblimg_sel[4] = {draw::DRAWTYPE_NUM+4, draw::DRAWTYPE_NUM, draw::DRAWTYPE_NUM+2, draw::DRAWTYPE_NUM+3};

    //

    for(type = 0; type < TOOLSUB_NUM; type++)
    {
        style = WS_HIDE;

        if(type == TOOLSUB_DRAW || type == TOOLSUB_BOXEDIT)
            style |= AXToolBar::TBS_TOOLTIP | AXToolBar::TBS_TOOLTIP_TR;

        m_ptbSub[type] = new AXToolBar(this, style, LF_EXPAND_W);

        m_ptbSub[type]->setImageList(g_res->pilToolSubTB);

        //

        ptbl  = NULL;
        imgno = tblimgno[type];

        switch(type)
        {
            //ブラシ/ドットペン
            case TOOLSUB_DRAW:
                m_ptbSub[type]->setToolTipTrGroup(strid::GROUP_DRAWTYPE);
                break;
            //選択
            case TOOLSUB_SEL:
                ptbl = tblimg_sel;
                break;
            //矩形編集
            case TOOLSUB_BOXEDIT:
                m_ptbSub[type]->setToolTipTrGroup(strid::GROUP_BOXEDIT);
                break;
        }

        //ボタン(共通処理)

        for(i = 0; i < bttcnt[type]; i++)
        {
            if(ptbl) imgno = ptbl[i];

            m_ptbSub[type]->addItem(CMDID_TOOLSUB + i, imgno++, i, AXToolBar::BF_CHECKGROUP, 0);
        }
    }

    //レイアウト時の位置・サイズを取得するため、セットしておく

    m_ptbSubNow = m_ptbSub[0];

    getLayout()->addItem(m_ptbSubNow);

    m_ptbSubNow->show();
}

//! サブタイプのツールバーを初期化
/*
    m_ptbSub[0] がレイアウト済みなので、他のツールバーをその位置・サイズに合わせる。
*/

void CToolWin::_initTB_sub()
{
    int i;
    AXRectSize rcs;

    m_ptbSub[0]->getRectSize(&rcs);

    for(i = 1; i < TOOLSUB_NUM; i++)
        m_ptbSub[i]->moveresize(rcs.x, rcs.y, rcs.w, rcs.h);
}


//=========================
//ハンドラ
//=========================


//! 閉じる（非表示）

BOOL CToolWin::onClose()
{
    m_pOwner->onCommand(strid::MENU_VIEW_TOOLWIN, 0, 0);

    return TRUE;
}

//! 通知

BOOL CToolWin::onNotify(AXWindow *pwin,UINT uNotify,ULONG lParam)
{
    if(pwin == m_pwidScale)
    {
        //表示倍率

        if(uNotify == CScaleRotBar::NOTIFY_BUTTON)
            draw::changeScale(1000);
        else
            draw::changeScale(m_pwidScale->getPos(), TRUE, !m_pwidScale->isDrag(), (uNotify == CScaleRotBar::NOTIFY_DOWN));
    }
    else if(pwin == m_pwidRot)
    {
        //回転
        //(押し時は、キャンバス基準位置を中央に)

        if(uNotify == CScaleRotBar::NOTIFY_BUTTON)
            draw::changeRotate(0);
        else
            draw::changeRotate(m_pwidRot->getPos(), TRUE, !m_pwidRot->isDrag(), (uNotify == CScaleRotBar::NOTIFY_DOWN));
    }

    return TRUE;
}

//! コマンド

BOOL CToolWin::onCommand(UINT uID,ULONG lParam,int from)
{
    //ツール

    if(uID >= CMDID_TOOL && uID < CMDID_TOOL + draw::TOOL_NUM)
    {
        draw::changeTool(uID - CMDID_TOOL);
        return TRUE;
    }

    //サブタイプ

    if(uID >= CMDID_TOOLSUB && uID < CMDID_TOOLSUB + 100)
    {
        draw::changeToolSubType(uID - CMDID_TOOLSUB);
        return TRUE;
    }

    return TRUE;
}
