/*$
Copyright (C) 2013-2016 Azel.

This file is part of AzPainter.

AzPainter is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

AzPainter is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.
$*/
/*
    CStatusBar - メインウィンドウのステータスバー
*/


#include "CStatusBar.h"

#include "CResource.h"
#include "global.h"
#include "drawdat.h"
#include "strid.h"

#include "AXLayout.h"
#include "AXLabel.h"
#include "AXApp.h"
#include "AXUtilStr.h"


//--------------------------

enum
{
    STRID_PAINT = 0,
    STRID_GRAD,
    STRID_TEXT,
    STRID_SEL,
    STRID_MOVE,
    STRID_CANVAS_ROTATE,
    STRID_ZOOM,
    STRID_SPOIT,

    STRID_BRUSH_FREE = 100,
    STRID_DOTPEN_FREE,

    STRID_DRAW_LINE = 200,
    STRID_DRAW_BOX,
    STRID_DRAW_CIRCLE,

    STRID_DRAW_POLYGON = 300,
};

//--------------------------



CStatusBar *CStatusBar::m_pSelf = NULL;


CStatusBar::CStatusBar(AXWindow *pParent)
    : AXWindow(pParent, WS_BK_FACE, LF_EXPAND_W)
{
    AXLayout *pl;

    m_pSelf = this;

    m_ptBkPos.x = m_ptBkPos.y = -10000;

    setFont(g_res->pfontSmall);

    //

    setLayout(pl = new AXLayoutHorz(0, 3));

    pl->setSpacing(1);

    pl->addItem(m_pPos = new AXLabel(this, AXLabel::LS_SUNKEN | AXLabel::LS_CENTER, 0));
    pl->addItem(m_pImgInfo = new AXLabel(this, AXLabel::LS_SUNKEN, 0));
    pl->addItem(m_pHelp = new AXLabel(this, 0, LF_EXPAND_W | LF_CENTER_Y));

    m_pPos->setMinWidth(110);
}

//! ポインタ位置テキストセット

void CStatusBar::setLabel_pos(int x,int y)
{
    if(m_ptBkPos.x != x || m_ptBkPos.y != y)
    {
        AXString str;

        str.setInt(x);
        str += " , ";
        str += y;

        m_pPos->setText(str);

        m_ptBkPos.set(x, y);
    }
}

//! イメージ情報テキストセット

void CStatusBar::setLabel_imginfo()
{
    AXString str;

    str.setInt(g_draw->nImgW);
    str += "x";
    str += g_draw->nImgH;
    str += ' ';
    str += g_draw->nImgDPI;
    str += "DPI";

    m_pImgInfo->setText(str);
    layout();
}

//! ヘルプ情報セット

void CStatusBar::setLabel_help()
{
    int tool,sub,id = -1;
    short id_poly[4] = {STRID_DRAW_BOX, STRID_DRAW_CIRCLE, STRID_DRAW_POLYGON, -1};

    tool = g_draw->tool.toolno;
    sub  = g_draw->tool.toolSubNo[tool];

    switch(tool)
    {
        //ブラシ描画・ドット
        case draw::TOOL_BRUSH:
        case draw::TOOL_DOTPEN:
            if(sub == 0)
                id = STRID_BRUSH_FREE + tool;
            else
                id = STRID_DRAW_LINE + sub - 1;
            break;
        //図形塗り・消し
        case draw::TOOL_POLYPAINT:
        case draw::TOOL_POLYERASE:
            id = id_poly[sub];
            break;

        case draw::TOOL_PAINT:
        case draw::TOOL_PAINTERASE:
            id = STRID_PAINT;
            break;
        case draw::TOOL_GRAD:
            id = STRID_GRAD;
            break;
        case draw::TOOL_TEXT:
            id = STRID_TEXT;
            break;
        case draw::TOOL_SEL:
            id = STRID_SEL;
            break;
        case draw::TOOL_MOVE:
            id = STRID_MOVE;
            break;
        case draw::TOOL_CANVROTATE:
            id = STRID_CANVAS_ROTATE;
            break;
        case draw::TOOL_SCALE:
            id = STRID_ZOOM;
            break;
        case draw::TOOL_SPOIT:
            id = STRID_SPOIT;
            break;
    }

    //

    if(id == -1)
        m_pHelp->setText((LPCUSTR)NULL);
    else
        m_pHelp->setText(_string(strid::GROUP_STATUS_HELP, id));
}

//! 長さと角度

void CStatusBar::setLabel_lineinfo(double dLen,int angle)
{
    AXString str;
    char m[32];
    int cm;

    cm = (int)(dLen * 2.54 / g_draw->nImgDPI * 100.0 + 0.5);

    str.setInt((int)dLen);
    str += " px ( ";

    AXIntToFloatStr(m, cm, 2);
    str += m;
    str += " cm ) : Angle ";

    AXIntToFloatStr(m, angle, 2);
    str += m;

    m_pHelp->setText(str);
}
