/*$
Copyright (C) 2013-2016 Azel.

This file is part of AzPainter.

AzPainter is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

AzPainter is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.
$*/
/*
    CMainWin [filter] - フィルタ
*/


#include "CMainWin.h"

#include "CFilterDlg.h"
#include "CProgressDlg.h"
#include "CFilterListWin.h"

#include "CConfig.h"
#include "CTileImage.h"
#include "CImage8.h"
#include "CLayerItem.h"
#include "CGradList.h"
#include "filterdraw.h"

#include "global.h"
#include "drawdat.h"
#include "strid.h"

#include "draw_main.h"
#include "draw_opfunc.h"

#include "filterdrawfunc.h"

#include "filterdlgdat.h"


//-------------------

enum
{
    FDF_DIALOG   = 1,    //ダイアログあり
    FDF_COLOROP  = 2,    //RGBカラーのみの操作
    FDF_COPYSRC  = 4,    //実際の処理時、元画像のコピーを作成する
    FDF_CLIPPING = 8,    //デフォルトでクリッピングON
};

struct FILTERCMDDAT
{
    const BYTE     *pDlgDat;
    FILTERDRAWFUNC  func;
    BYTE            flags;
};

BOOL beforeFilter_mes(UINT);
void runFilter(UINT,const BYTE *,FILTERDRAWFUNC,UINT,int=0);
void *thread_filter_func(void *);

//-------------------

FILTERCMDDAT g_filtercmddat[] = {
    {filterdat::col_brightcont, filterdraw::color_brightcont, FDF_DIALOG|FDF_COLOROP},
    {filterdat::col_gamma, filterdraw::color_gamma, FDF_DIALOG|FDF_COLOROP},
    {filterdat::col_level, filterdraw::color_level, FDF_DIALOG|FDF_COLOROP},
    {filterdat::col_rgb, filterdraw::color_rgb, FDF_DIALOG|FDF_COLOROP},
    {filterdat::col_hsv, filterdraw::color_hsv, FDF_DIALOG|FDF_COLOROP},
    {NULL, filterdraw::color_nega, FDF_COLOROP},
    {NULL, filterdraw::color_grayscale, FDF_COLOROP},
    {NULL, filterdraw::color_sepia, FDF_COLOROP},
    {filterdat::col_threshold, filterdraw::color_threshold, FDF_DIALOG|FDF_COLOROP},
    {filterdat::col_threshold_dither, filterdraw::color_threshold_dither, FDF_DIALOG|FDF_COLOROP},
    {filterdat::col_posterize, filterdraw::color_posterize, FDF_DIALOG|FDF_COLOROP},
    {filterdat::colop_drawcol_rep, filterdraw::colorop_drawcol_rep, FDF_DIALOG|FDF_COLOROP},
    {filterdat::blur_blur, filterdraw::blur_blur, FDF_DIALOG},
    {filterdat::blur_gauss, filterdraw::blur_gauss, FDF_DIALOG},
    {filterdat::blur_motion, filterdraw::blur_motion, FDF_DIALOG|FDF_COPYSRC},
    {filterdat::blur_radial, filterdraw::blur_radial, FDF_DIALOG|FDF_COPYSRC},
    {filterdat::blur_lens, filterdraw::blur_lens, FDF_DIALOG|FDF_COPYSRC},
    {filterdat::draw_frame, filterdraw::draw_frame, FDF_DIALOG},
    {filterdat::draw_line, filterdraw::draw_line, FDF_DIALOG},
    {filterdat::draw_check, filterdraw::draw_check, FDF_DIALOG},
    {filterdat::draw_rndpoint, filterdraw::draw_rndpoint, FDF_DIALOG},
    {filterdat::draw_cloud, filterdraw::draw_cloud, FDF_DIALOG},
    {filterdat::draw_amitone1, filterdraw::draw_amitone1, FDF_DIALOG},
    {filterdat::draw_amitone2, filterdraw::draw_amitone2, FDF_DIALOG},
    {filterdat::pix_mozaic, filterdraw::mozaic, FDF_DIALOG},
    {filterdat::pix_crystal, filterdraw::crystal, FDF_DIALOG},
    {filterdat::pix_halftone, filterdraw::halftone, FDF_DIALOG},
    {filterdat::edge_sharp, filterdraw::sharp, FDF_DIALOG|FDF_COPYSRC},
    {filterdat::edge_unsharpmask, filterdraw::unsharpmask, FDF_DIALOG},
    {NULL, filterdraw::edge_sobel, FDF_COPYSRC|FDF_COLOROP|FDF_CLIPPING},
    {NULL, filterdraw::edge_laplacian, FDF_COPYSRC|FDF_COLOROP|FDF_CLIPPING},
    {filterdat::eff_glow, filterdraw::eff_glow, FDF_DIALOG},
    {filterdat::eff_rgbshift, filterdraw::eff_rgbshift, FDF_DIALOG|FDF_COPYSRC},
    {filterdat::eff_oilpaint, filterdraw::eff_oilpaint, FDF_DIALOG|FDF_COPYSRC},
    {filterdat::eff_emboss, filterdraw::eff_emboss, FDF_DIALOG|FDF_COPYSRC},
    {filterdat::eff_noise, filterdraw::eff_noise, FDF_DIALOG},
    {filterdat::eff_diffusion, filterdraw::eff_diffusion, FDF_DIALOG|FDF_COPYSRC},
    {filterdat::eff_scratch, filterdraw::eff_scratch, FDF_DIALOG|FDF_COPYSRC},
    {filterdat::eff_median, filterdraw::eff_median, FDF_DIALOG|FDF_COPYSRC},
    {filterdat::eff_blurring, filterdraw::eff_blurring, FDF_DIALOG|FDF_COPYSRC},
    {filterdat::trans_wave, filterdraw::trans_wave, FDF_DIALOG|FDF_COPYSRC},
    {filterdat::trans_ripple, filterdraw::trans_ripple, FDF_DIALOG|FDF_COPYSRC},
    {filterdat::trans_polar, filterdraw::trans_polar, FDF_DIALOG|FDF_COPYSRC|FDF_CLIPPING},
    {filterdat::trans_radialshift, filterdraw::trans_radialshift, FDF_DIALOG|FDF_COPYSRC},
    {filterdat::trans_swirl, filterdraw::trans_swirl, FDF_DIALOG|FDF_COPYSRC},
    {NULL, filterdraw::lumtoalpha, FDF_COLOROP},
    {NULL, filterdraw::dotthinning, 0},
    {filterdat::etc_antialiasing, filterdraw::antialiasing, FDF_DIALOG|FDF_COPYSRC|FDF_CLIPPING},
    {filterdat::etc_hemming, filterdraw::hemming, FDF_DIALOG|FDF_COPYSRC},
    {filterdat::etc_3Dbutton, filterdraw::button3D, FDF_DIALOG|FDF_COLOROP},
    {filterdat::etc_shift, filterdraw::shift, FDF_DIALOG|FDF_COPYSRC},
    {filterdat::draw_edge, filterdraw::draw_edge, FDF_DIALOG|FDF_COPYSRC},
    {filterdat::edge_highpass, filterdraw::highpass, FDF_DIALOG},
    {filterdat::comic_concline, filterdraw::comic_concline_flash, FDF_DIALOG},
    {filterdat::comic_flash, filterdraw::comic_concline_flash, FDF_DIALOG},
    {filterdat::comic_popupflash, filterdraw::comic_popupflash, FDF_DIALOG},
    {filterdat::comic_uniflash, filterdraw::comic_uniflash, FDF_DIALOG},
    {filterdat::comic_uniflash_wave, filterdraw::comic_uniflash_wave, FDF_DIALOG},
    {NULL, filterdraw::color_gradmap, 0}
};

//-------------------




//=============================
// コマンド
//=============================


//! フィルタコマンド

void CMainWin::_command_filter(UINT id,int from)
{
    FILTERCMDDAT *p;

    if(id >= strid::MENU_FILTER_COLOROP_DRAWCOL_TP && id <= strid::MENU_FILTER_COLOROP_TP_DRAWCOL)
    {
        //色操作
        runFilter(0, NULL, filterdraw::colorop_common, 0, id - strid::MENU_FILTER_COLOROP_DRAWCOL_TP);
    }
    else if(id >= strid::MENU_FILTER_ALPHA1_TP_TP && id <= strid::MENU_FILTER_ALPHA1_LUMREV)
    {
        //アルファ操作1
        runFilter(0, NULL, filterdraw::alphaop1_common, 0, id - strid::MENU_FILTER_ALPHA1_TP_TP);
    }
    else if(id >= strid::MENU_FILTER_ALPHA2_LUMREV && id <= strid::MENU_FILTER_ALPHA2_GRAYSCALE)
    {
        //アルファ操作2

        if(id == strid::MENU_FILTER_ALPHA2_TEXTURE && !g_draw->pimg8OptTex->isExist())
        {
            //テクスチャ適用 : オプションテクスチャ指定がない時

            errMes(strid::GROUP_MESSAGE, strid::MES_FILTER_NONEOPTTEX);
            return;
        }

        runFilter(0, NULL, filterdraw::alphaop2_common, 0, id - strid::MENU_FILTER_ALPHA2_LUMREV);
    }
    else
    {
        //そのほか

        p = g_filtercmddat + (id - strid::MENU_FILTER_COLOR_BRIGHTCONT);

        runFilter(id, p->pDlgDat, p->func, p->flags);
    }

    //フィルタ一覧から実行された時は、選択を消す

    if(from == -1)
        FILTERLISTWIN->eraseSelect();
}


//=============================
// 共通処理
//=============================


//! フィルタ実行前、メッセージ表示

BOOL beforeFilter_mes(UINT uID,UINT uFlags)
{
    int check,id = -1;

    check = draw::checkDrawLayer();

    /* カレントレイヤがフォルダ or ロック、
       またはRGBカラー操作でカレントレイヤがA16/A1の場合 */

    if(check == draw::CHECKDRAW_FOLDER)
        id = strid::MES_LAYER_FOLDER;
    else if(check == draw::CHECKDRAW_LOCK)
        id = strid::MES_LAYER_LOCK;
    else if((uFlags & FDF_COLOROP) && g_draw->pcurlayer->isColTypeOnlyA())
        id = strid::MES_FILTER_COLOROP;
    else if(uID == strid::MENU_FILTER_COLOR_GRADMAP && GRADLIST->getCnt() == 0)
        //グラデーションマップ:カスタムがひとつもない
        id = strid::MES_FILTER_NONEGRAD;

    //

    if(id == -1)
        return FALSE;
    else
    {
        MAINWIN->errMes(strid::GROUP_MESSAGE, id);
        return TRUE;
    }
}

//! フィルタ処理実行

void runFilter(UINT uTitleID,const BYTE *pDat,FILTERDRAWFUNC func,UINT uFlags,int subval)
{
    CFilterDlg *pdlg;
    CProgressDlg *pProgDlg;
    FILTERDRAW info;
    AXRect rc;

    if(beforeFilter_mes(uTitleID, uFlags)) return;

    //

    AXMemZero(&info, sizeof(FILTERDRAW));

    info.funcDraw  = func;
    info.dwDrawCol = g_conf->dwDrawCol;
    info.bClipping = ((uFlags & FDF_CLIPPING) != 0);

    //ダイアログ

    if(uFlags & FDF_DIALOG)
    {
        info.pProgDlg = NULL;
        info.bPreview = TRUE;

        pdlg = new CFilterDlg(MAINWIN, uTitleID, pDat, &info);
        if(!pdlg->runDialog()) return;
    }

    //処理範囲

    if(g_draw->work.rcfSel.flag)
        g_draw->work.rcfSel.toRect(&rc);
    else
        draw::getCurImg()->getEnableDrawRectPixel(&rc);

    info.rs.set(rc);

    if(!filterdraw::clipInCanvas(&info.rs, info))
        return;

    //処理

    info.bPreview = FALSE;
    info.bCopySrc = ((uFlags & FDF_COPYSRC) != 0);
    info.ntmp[0]  = subval;

    pProgDlg = new CProgressDlg(MAINWIN, thread_filter_func, (LPVOID)&info);

    if(!pProgDlg->run())
        MAINWIN->errMes(strid::GROUP_MESSAGE, strid::MES_FAILED);
}

//! フィルタ処理スレッド

void *thread_filter_func(void *pParam)
{
    CProgressDlg *pProgDlg = (CProgressDlg *)pParam;
    FILTERDRAW *pinfo;
    CTileImage *pimgSrc = NULL,*pimgDst;
    BOOL ret = FALSE;

    pinfo = (FILTERDRAW *)pProgDlg->m_pParam1;

    pimgDst = draw::getCurImg();

    //UNDO開始

    draw::beginDrawUndo();

    //描画準備

    draw::setBeforeDraw_filter(FALSE);

    //

    pinfo->pimgDst  = pimgDst;
    pinfo->pimgSrc  = pimgDst;
    pinfo->pProgDlg = pProgDlg;

    //コピーを作成してソースとする

    if(pinfo->bCopySrc)
    {
        pimgSrc = draw::allocTileImage(pimgDst->getColType());

        if(!pimgSrc->copy(*pimgDst))
        {
            delete pimgSrc;
            goto END;
        }

        pinfo->pimgSrc = pimgSrc;
    }

    //処理実行

    pProgDlg->beginProgSub(50, pinfo->rs.h, TRUE);

    ret = (*pinfo->funcDraw)(*pinfo);

    if(pimgSrc) delete pimgSrc;

    //UNDO後処理

    draw::commonAfterDraw();

    //終了

END:
    pProgDlg->endThread(ret);

    return NULL;
}

