/*$
Copyright (C) 2013-2016 Azel.

This file is part of AzPainter.

AzPainter is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

AzPainter is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.
$*/
/*
    CMainWin : レイヤ関連コマンド
*/


#include "CMainWin.h"

#include "CLayerWin.h"
#include "CProgressDlg.h"
#include "dialog_layer.h"

#include "CConfig.h"
#include "CLayerList.h"
#include "CLayerItem.h"
#include "CTileImage.h"
#include "CApp.h"

#include "drawdat.h"
#include "draw_layer.h"
#include "draw_update.h"

#include "global.h"
#include "strid.h"

#include "AXFileDialog.h"
#include "AXStrDialog.h"


//! レイヤコマンド

BOOL CMainWin::_cmd_layer(UINT id)
{
    switch(id)
    {
        //新規レイヤ
        case strid::MENU_LAYER_NEWLAYER:
            _layerNew();
            break;
        //新規フォルダ
        case strid::MENU_LAYER_NEWFOLDER:
            _layerNewFolder();
            break;
        //画像から新規レイヤ
        case strid::MENU_LAYER_FROMIMG:
            _layerFromImg();
            break;
        //複製
        case strid::MENU_LAYER_COPY:
            draw::layer_copy();
            break;
        //削除
        case strid::MENU_LAYER_DELETE:
            draw::layer_delete();
            break;
        //クリア
        case strid::MENU_LAYER_CLEAR:
            draw::layer_clear();
            break;
        //下レイヤに移す
        case strid::MENU_LAYER_IMGDROP:
            draw::layer_combine(TRUE);
            break;
        //下レイヤに結合
        case strid::MENU_LAYER_COMBINE:
            draw::layer_combine(FALSE);
            break;
        //レイヤ名変更
        case strid::MENU_LAYER_RENAME:
            _layerRename(g_draw->pcurlayer);
            break;
        //カラータイプ変更
        case strid::MENU_LAYER_CHANGECOLTYPE:
            _layerChangeColType(g_draw->pcurlayer);
            break;
        //複数レイヤの結合
        case strid::MENU_LAYER_COMBINESOME:
            _layerCombineSome();
            break;
        //画像の統合
        case strid::MENU_LAYER_UNITE:
            draw::layer_unite();
            break;

        //左右反転
        case strid::MENU_LAYER_EDIT_HREV:
            draw::layer_revHorzVert(TRUE);
            break;
        //上下反転
        case strid::MENU_LAYER_EDIT_VREV:
            draw::layer_revHorzVert(FALSE);
            break;
        //左に90度回転
        case strid::MENU_LAYER_EDIT_LROT:
            draw::layer_rotate90(TRUE);
            break;
        //右に90度回転
        case strid::MENU_LAYER_EDIT_RROT:
            draw::layer_rotate90(FALSE);
            break;

        //すべて表示
        case strid::MENU_LAYER_VIEW_ALLSHOW:
            draw::layer_showAll(1);
            break;
        //すべて非表示
        case strid::MENU_LAYER_VIEW_ALLHIDE:
            draw::layer_showAll(0);
            break;
        //カレントのみ表示
        case strid::MENU_LAYER_VIEW_ONLYCUR:
            draw::layer_showAll(2);
            break;
        //チェックレイヤの表示反転
        case strid::MENU_LAYER_VIEW_TOGGLECHECK:
            draw::layer_showCheckRev();
            break;
        //通常レイヤの表示反転
        case strid::MENU_LAYER_VIEW_TOGGLE_NORMAL:
            draw::layer_showToggleNormal();
            break;

        //リンクすべてOFF
        case strid::MENU_LAYER_CHECK_LINKOFF:
            g_draw->player->flagOffAll(~CLayerItem::FLAG_LINK);
            LAYERWIN->updateLayerAll();
            break;
        //チェックすべてOFF
        case strid::MENU_LAYER_CHECK_CHECKOFF:
            g_draw->player->flagOffAll(~CLayerItem::FLAG_CHECK);
            LAYERWIN->updateLayerAll();
            break;

        //保存
        case strid::MENU_LAYER_SAVE:
            _layerSave();
            break;

        //上へ
        case strid::MENU_LAYER_TMP_MOVEUP:
            draw::layer_moveUpDown(TRUE);
            break;
        //下へ
        case strid::MENU_LAYER_TMP_MOVEDOWN:
            draw::layer_moveUpDown(FALSE);
            break;
    }

    return TRUE;
}

//! レイヤ名変更

void CMainWin::_layerRename(CLayerItem *pItem)
{
    AXString str;

    _trgroup(strid::GROUP_LAYER);

    str = pItem->m_strName;

    if(AXStrDialog::getString(this,
            _str(strid::LAYER_RENAME_TITLE),
            _string(strid::GROUP_WORD, strid::WORD_NAME), &str))
    {
        pItem->m_strName = str;

        LAYERWIN->updateLayerItem(pItem);
    }
}

//! 新規レイヤ

void CMainWin::_layerNew()
{
    CNewLayerDlg *pdlg;
    CNewLayerDlg::INFO info;

    info.strName = "layer";
    info.strName += g_draw->player->getNormalLayerCnt();

    pdlg = new CNewLayerDlg(this, &info);

    if(pdlg->runDialog())
        draw::layer_new(info.strName, info.nBlendMode, info.nColType, info.dwCol);
}

//! 新規フォルダ

void CMainWin::_layerNewFolder()
{
    AXString str;

    _trgroup(strid::GROUP_LAYER);

    str = _str(strid::LAYER_FOLDER);

    if(AXStrDialog::getString(this,
            _str(strid::LAYER_NEWFOLDER_TITLE),
            _string(strid::GROUP_WORD, strid::WORD_NAME), &str))
    {
        draw::layer_newFolder(str);
    }
}

//! 画像から新規レイヤ

void CMainWin::_layerFromImg()
{
    AXString str,filter;

    filter = "BMP/PNG/GIF/JPEG/APLD\t*.bmp;*.png;*.gif;*.jpg;*.jpeg;*.apld\tAll Files\t*\t";

    if(AXFileDialog::openFile(this, filter, 0, g_conf->strOpenDir, 0, &str))
    {
        if(!draw::layer_fromImg(str))
            errMes(strid::GROUP_MESSAGE, strid::MES_FAILED);
        else
            draw::updateAllAndLayer();
    }
}

//! カラータイプ変更

void CMainWin::_layerChangeColType(CLayerItem *pItem)
{
    CLayerColTypeDlg *pdlg;
    int ret;

    if(pItem->isFolder()) return;

    pdlg = new CLayerColTypeDlg(this, pItem->m_nColType);

    ret = pdlg->runDialog();
    if(ret < 0) return;

    //

    if(!draw::layer_changeColType(pItem, ret & 0x7f, ret & 0x80))
        errMes(strid::GROUP_MESSAGE, strid::MES_FAILED);
}

//! 複数レイヤの結合

void CMainWin::_layerCombineSome()
{
    CLayerCombineSomeDlg *pdlg;
    CLayerCombineSomeDlg::INFO info;

    info.bFolder     = g_draw->pcurlayer->isFolder();
    info.bCheckExist = g_draw->player->isExistCheckImg();

    //

    pdlg = new CLayerCombineSomeDlg(this, &info);

    if(pdlg->runDialog())
        draw::layer_combinesome(info.type, info.bNewLayer, info.coltype);
}

// [スレッド] レイヤ保存

void *thread_saveLayer(void *pParam)
{
    CProgressDlg *pdlg = (CProgressDlg *)pParam;
    AXString *pName = (AXString *)pdlg->m_pParam1;
    int *pType = (int *)pdlg->m_pParam2;
    BOOL ret;

    if(*pType == 0)
        ret = g_draw->pcurlayer->saveAPLD(*pName, pdlg);
    else
        ret = g_draw->pcurlayer->m_pimg->savePNG32bit(*pName, g_draw->nImgDPI, pdlg);

    pdlg->endThread(ret);

    return NULL;
}

//! レイヤをファイルに保存

void CMainWin::_layerSave()
{
    AXString str,filter,dir;
    int type;
    CProgressDlg *pdlg;

    if(g_draw->pcurlayer->isFolder()) return;

    //ファイル名

    filter = "AzPainter Layer File (*.apld)\t*.apld\tPNG 32bit (*.png)\t*.png";

    if(g_conf->strLayerSaveDir.isEmpty())
        dir.path_removeFileName(m_strFileName);
    else
        dir = g_conf->strLayerSaveDir;

    if(!AXFileDialog::saveFile(this, filter, 0, dir, 0, &str, &type))
        return;

    //拡張子

    if(type == 0)
        str.path_setExt("apld");
    else
        str.path_setExt("png");

    //ディレクトリ保存

    g_conf->strLayerSaveDir.path_removeFileName(str);

    //保存

    pdlg = new CProgressDlg(this, thread_saveLayer, &str, &type);

    if(!pdlg->run())
        errMes(strid::GROUP_MESSAGE, strid::MES_FAILED_SAVE);
}
