/*$
Copyright (C) 2013-2016 Azel.

This file is part of AzPainter.

AzPainter is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

AzPainter is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.
$*/
/*
    CFilterListWin - フィルタ一覧ウィンドウ
*/


#include "CFilterListWin.h"

#include "CMainWin.h"
#include "CConfig.h"

#include "AXLayout.h"
#include "AXTreeView.h"
#include "AXMenu.h"
#include "AXMenuItem.h"
#include "AXMenuBar.h"

#include "global.h"
#include "strid.h"


CFilterListWin *CFilterListWin::m_pSelf = NULL;


CFilterListWin::CFilterListWin(AXWindow *pOwner,UINT addstyle)
    : AXTopWindow(pOwner,
                  WS_HIDE | WS_TITLE | WS_CLOSE | WS_BORDER | addstyle)
{
    AXLayout *pl;

    m_pSelf = this;

    setTitle("filter list");

    attachAccel(((AXTopWindow *)m_pOwner)->getAccel());

    //ツリー

    setLayout(pl = new AXLayoutVert());

    pl->addItem(m_ptree = new AXTreeView(this, AXScrollView::SVS_HORZVERT, LF_EXPAND_WH));

    m_ptree->setFlag_focusDisableKey();

    _initTree();
}

//! ツリー初期化

void CFilterListWin::_initTree()
{
    AXMenu *pmenu;
    AXMenuItem *psub,*p;
    AXTreeViewItem *pParent;

    pmenu = (MAINWIN->getMenuBar())->getSubMenu(strid::MENU_TOP_FILTER);

    for(psub = pmenu->getTopItem(); psub; psub = psub->next())
    {
        pParent = m_ptree->addItem(NULL, psub->m_strText, -1, AXTreeViewItem::FLAG_EXPAND, 0);

        if(!psub->m_pSubMenu) continue;

        for(p = (psub->m_pSubMenu)->getTopItem(); p; p = p->next())
        {
            if(!(p->m_uFlags & AXMenu::MIF_SEP))
                m_ptree->addItem(pParent, p->m_strText, -1, 0, p->m_uID);
        }
    }
}

//! 表示/非表示 切り替え

void CFilterListWin::showToggle()
{
    if(g_conf->isFilterWin())
        showRestore();
    else
        hide();
}

//! 選択を消す

void CFilterListWin::eraseSelect()
{
    m_ptree->setFocusItem(NULL);
}

//! 閉じる（非表示）

BOOL CFilterListWin::onClose()
{
    m_pOwner->onCommand(strid::MENU_VIEW_FILTERLISTWIN, 0, 0);

    return TRUE;
}

//! 通知

BOOL CFilterListWin::onNotify(AXWindow *pwin,UINT uNotify,ULONG lParam)
{
    if(pwin == m_ptree && uNotify == AXTreeView::TVN_SELCHANGE)
    {
        AXTreeViewItem *p = m_ptree->getFocusItem();

        if(p && p->m_lParam)
            MAINWIN->sendCommand(p->m_lParam, 0, -1);
    }

    return TRUE;
}
