/*$
Copyright (C) 2013-2016 Azel.

This file is part of AzPainter.

AzPainter is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

AzPainter is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.
$*/
/*
    CBrushWin - ブラシウィンドウ
*/


#include "CBrushWin.h"

#include "CBrushWin_sizeList.h"
#include "CBrushWin_brushList.h"
#include "CBrushWin_value.h"

#include "CBrushList.h"

#include "CMainWin.h"
#include "CConfig.h"
#include "CResource.h"

#include "global.h"
#include "strid.h"

#include "AXLayout.h"
#include "AXSplitter.h"
#include "AXApp.h"



CBrushWin *CBrushWin::m_pSelf = NULL;


CBrushWin::CBrushWin(AXWindow *pOwner,UINT addstyle)
    : AXTopWindow(pOwner,
                  WS_HIDE | WS_TITLE | WS_CLOSE | WS_BORDER | addstyle)
{
    AXLayout *pl;

    m_pSelf = this;

    //

    setTitle("brush");

    if(g_res->pfontSubWin)
        setFont(g_res->pfontSubWin);

    attachAccel(((AXTopWindow *)m_pOwner)->getAccel());

    //ウィジェット

    setLayout(pl = new AXLayoutVert);

    pl->addItem(m_pwidSize = new CBrushWin_sizeList(this, g_conf->nBrushWinH[0]));
    pl->addItem(new AXSplitter(this, AXSplitter::SPLS_VERT));

    pl->addItem(m_pwidList = new CBrushWin_brushList(this, g_conf->nBrushWinH[1], g_res->pfontSmall));
    pl->addItem(new AXSplitter(this, AXSplitter::SPLS_VERT));

    pl->addItem(m_pwidValue = new CBrushWin_value(this));

    //

    m_pwidValue->setValue();
}

//! 表示/非表示 切り替え

void CBrushWin::showToggle()
{
    if(g_conf->isBrushWin())
        showRestore();
    else
        hide();
}

//! 子ウィンドウの高さ取得

void CBrushWin::getWinH()
{
    g_conf->nBrushWinH[0] = m_pwidSize->getHeight();
    g_conf->nBrushWinH[1] = m_pwidList->getHeight();
}

//! ブラシサイズを直接セット

void CBrushWin::setBrushSize(int size)
{
    BRUSHLIST->changeValRadius(size, TRUE);

    m_pwidValue->setValRadius();
}

//! ブラシ選択を上下左右に移動

void CBrushWin::moveSelBrush(int dir)
{
    if(m_pwidList->moveSelBrush(dir))
        m_pwidValue->setValue();
}

//! 登録ブラシ/直前のブラシ切替

void CBrushWin::toggleRegBrush()
{
    if(BRUSHLIST->toggleRegItem())
    {
        m_pwidList->drawArea();
        m_pwidValue->setValue();
    }
}


//=========================
// ハンドラ
//=========================


//! 閉じる（非表示）

BOOL CBrushWin::onClose()
{
    m_pOwner->onCommand(strid::MENU_VIEW_BRUSHWIN, 0, 0);

    return TRUE;
}

//! 通知

BOOL CBrushWin::onNotify(AXWindow *pwin,UINT uNotify,ULONG lParam)
{
    if(pwin == m_pwidSize)
        //サイズリストからサイズが選択された時
        setBrushSize((int)lParam);
    else if(pwin == m_pwidList)
        //ブラシ選択変更時
        m_pwidValue->setValue();

    return TRUE;
}
