/*$
Copyright (C) 2013-2016 Azel.

This file is part of AzPainter.

AzPainter is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

AzPainter is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.
$*/

#ifndef _AZPT_SUBWIDGET_COLOR_H_
#define _AZPT_SUBWIDGET_COLOR_H_

#include "AXWindow.h"
#include "CXImage.h"

class AXScrollBar;

//!< 描画色/背景色

class CColSub_drawcol:public AXWindow
{
protected:
    enum{ SPACE = 10 };

public:
    CColSub_drawcol(AXWindow *pParent,DWORD dwPadding);

    void paintOnlyDrawCol();

    virtual BOOL onPaint(AXHD_PAINT *phd);
    virtual BOOL onButtonDown(AXHD_MOUSE *phd);
};

//!< 色マスクタイプボタン

class CColSub_colmasktype:public AXWindow
{
protected:
    int m_nTextW[2], m_nOneW;

    enum{
        XSPACE = 6,
        YSPACE = 3
    };

public:
    CColSub_colmasktype(AXWindow *pParent);

    virtual void calcDefSize();
    virtual BOOL onPaint(AXHD_PAINT *phd);
    virtual BOOL onButtonDown(AXHD_MOUSE *phd);
};

//!< 色マスク

class CColSub_colmask:public AXWindow
{
protected:
    CXImage m_img;

    enum
    {
        ONESIZE = 19
    };

public:
    CColSub_colmask(AXWindow *pParent);

    void draw();

    virtual BOOL onPaint(AXHD_PAINT *phd);
    virtual BOOL onButtonDown(AXHD_MOUSE *phd);
};

//!< グラデーションパレット

class CColSub_grad:public AXWindow
{
public:
    enum
    {
        NOTIFY_CHANGE_LEFT,
        NOTIFY_CHANGE_RIGHT,
        NOTIFY_COLOR
    };

protected:
    AXImage m_img;

    DWORD   m_dwCol1,
            m_dwCol2;
    int     m_sr,m_sg,m_sb,
            m_er,m_eg,m_eb,
            m_nDragX;
    BOOL    m_fDrag;

    void _changeCol();
    void _draw();
    void _moveGrad(int wx);

    enum{ SPACE = 4 };

public:
    CColSub_grad(AXWindow *pParent,UINT uID,DWORD col1,DWORD col2);

    DWORD getColLeft() const { return m_dwCol1; }
    DWORD getColRight() const { return m_dwCol2; }

    virtual BOOL onPaint(AXHD_PAINT *phd);
    virtual BOOL onSize();
    virtual BOOL onButtonDown(AXHD_MOUSE *phd);
    virtual BOOL onButtonUp(AXHD_MOUSE *phd);
    virtual BOOL onMouseMove(AXHD_MOUSE *phd);
};

//!< HLSパレット

class CColSub_hlspal:public AXWindow
{
protected:
    AXImage m_img;

    BOOL    m_fDrag;
    int     m_nDragX,m_nDragY;

    void _drawFirst();
    void _drawTopCursor();
    void _moveTop(int winx);
    void _movePal(int wx,int wy);

    enum
    {
        TOPH    = 10,
        TOP_H_W = 6,
        TOP_LS_W = 12,
        TOPSP   = 8,
        PALW    = 12,
        PALH    = 8,
        PALY    = TOPH + TOPSP,
        PALXCNT = 15,
        PALYCNT = 10,

        DRAG_TOP = 1,
        DRAG_PAL = 2
    };

public:
    CColSub_hlspal(AXWindow *pParent);

    void drawAll();
    void drawPalette();

    virtual BOOL onPaint(AXHD_PAINT *phd);
    virtual BOOL onButtonDown(AXHD_MOUSE *phd);
    virtual BOOL onButtonUp(AXHD_MOUSE *phd);
    virtual BOOL onMouseMove(AXHD_MOUSE *phd);
};

//!< パレット選択タブ

class CColSub_paltab:public AXWindow
{
protected:
    int m_nOneH;

    enum
    {
        YSPACE = 2
    };

public:
    CColSub_paltab(AXWindow *pParent);

    virtual void calcDefSize();
    virtual BOOL onPaint(AXHD_PAINT *phd);
    virtual BOOL onButtonDown(AXHD_MOUSE *phd);
};

//!< パレット

class CColSub_pal:public AXWindow
{
protected:
    AXImage     m_img;
    AXScrollBar *m_pScr;

    int     m_nXCnt,
            m_fDown,
            m_nDownNo,
            m_nMoveNo,
            m_nOneW,
            m_nOneH;
    AXPoint m_ptDown,
            m_ptBk;

    void _setScroll();
    int _getPalNo(int x,int y);
    void _drawCursor(BOOL bErase);
    void _drawDDCursor(BOOL bErase);
    void _runMenu(int x,int y);

    enum
    {
        DOWNF_POS = 1,
        DOWNF_NORMAL,
        DOWNF_MOVE,
        DOWNF_GRAD
    };

public:
    CColSub_pal(AXWindow *pParent,AXScrollBar *pScr);

    void draw();
    void changeAll();
    void changeOneSize();

    virtual BOOL onSize();
    virtual BOOL onPaint(AXHD_PAINT *phd);
    virtual BOOL onButtonDown(AXHD_MOUSE *phd);
    virtual BOOL onButtonUp(AXHD_MOUSE *phd);
    virtual BOOL onMouseMove(AXHD_MOUSE *phd);
};

#endif
