/*$
Copyright (C) 2013-2016 Azel.

This file is part of AzPainter.

AzPainter is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

AzPainter is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.
$*/

#ifndef _AZPT_DEFSTRUCT_H_
#define _AZPT_DEFSTRUCT_H_

#include "AXDef.h"
#include "AXRect.h"

class CTileImage;
class CImage8;
union RGBFIX15;


union RGBAFIX15
{
    struct{ WORD r,g,b,a; };
    WORD c[4];

    void zero() { r = g = b = a = 0; }
    void set(WORD rr,WORD gg,WORD bb,WORD aa){ r = rr, g = gg, b = bb, a = aa; }
    void set(DWORD col);
    BOOL operator ==(const RGBAFIX15 &src)
    {
        return ((r == src.r && g == src.g && b == src.b && a == src.a) || (a == 0 && src.a == 0)) ;
    }
    BOOL compareColMask(const RGBAFIX15 &c)
    {
        return (a && c.a && r == c.r && g == c.g && b == c.b);
    }
    BOOL compareRGB(const RGBAFIX15 &src)
    {
        return (r == src.r && g == src.g && b == src.b);
    }
    DWORD toDWORD();
};

union RGBFIX15
{
    struct{ WORD r,g,b; };
    WORD c[3];

    void set(WORD rr,WORD gg,WORD bb) { r = rr, g = gg, b = bb; }
    void set(DWORD col);
    void set(const RGBAFIX15 src) { r = src.r, g = src.g, b = src.b; }
    void white() { r = g = b = 0x8000; }
    DWORD toDWORD();
};

struct RGBADOUBLE
{
    double r,g,b,a;

    void zero() { r = g = b = a = 0; }
};

struct DPOINT
{
    double x,y;

    void zero() { x = y = 0; }
};

struct DRECT
{
    double x1,y1,x2,y2;
};

struct DRAWPOINT
{
    double x,y,press;
};

struct FLAGRECT
{
    int x1,y1,x2,y2,flag;

    void clear() { flag = FALSE; }
    void zero() { x1 = y1 = x2 = y2 = flag = 0; }
    void set(int _x1,int _y1,int _x2,int _y2) { x1 = _x1, y1 = _y1, x2 = _x2, y2 = _y2, flag = TRUE; }
    void set(const AXRectSize &rcs);
    void toRect(AXRect *prc) { prc->left = x1, prc->top = y1, prc->right = x2, prc->bottom = y2; }
    void fromRect(const AXRect &rc){ x1 = rc.left, y1 = rc.top, x2 = rc.right, y2 = rc.bottom, flag = TRUE; }
    void incPoint(int x,int y);
    void combine(const FLAGRECT &src);
    void move(int mx,int my);
    void combineMove(const FLAGRECT &src,int mx,int my);
    void inflate(int n);
};

struct RECTANDSIZE
{
    int x1,y1,x2,y2,w,h;

    void set(const AXRect &rc);
    void set(const FLAGRECT &rcf);
    void inflate(int n);
    void toRect(AXRect *prc) const
    {
        prc->left = x1, prc->top = y1, prc->right = x2, prc->bottom = y2;
    }
};

//! レイヤ画像情報

struct TILEIMGINFO
{
    int nArrayW,nArrayH,nOffX,nOffY;
};

//! ブラシ描画用パラメータ

struct BRUSHDRAWPARAM
{
    double  dShapeHard,     //!< 円形形状の硬さ
            dRadius,        //!< 半径サイズ(px)
            dOpacity,       //!< 最大濃度(0-1)
            dMinSize,       //!< サイズ最小(0-1)
            dMinOpacity,    //!< 濃度最小(0-1)
            dIntervalSrc,   //!< 通常の間隔
            dInterval,      //!< 実際の間隔（ぼかし時は間隔で調整するため）
            dGammaSize,     //!< 筆圧ガンマ値
            dGammaOpacity,
            dRandSizeMin,   //!< ランダムサイズ最小
            dRandPosLen,    //!< ランダム位置距離
            dWater[3];
    int     nRotAngle,      //!< 回転角度(0-511)
            nRotRandom,     //!< 回転ランダム幅
            nRoughVal,      //!< 粗さ(2〜、2未満で無効。大きいほど粗い)
            nHoseiType,     //!< 手ぶれ補正 タイプ
            nHoseiStr;      //!< 手ぶれ補正 過去の参照点の数
    DWORD   dwFlags;        //!< フラグ(BRUSHDRAWFLAG)

    CImage8 *pimgBrush,     //!< 作業用
            *pimgTexture;
};

enum BRUSHDRAWFLAG
{
    BRUSHDF_NONEAA      = 1,
    BRUSHDF_CURVE       = 2,
    BRUSHDF_RND_SIZE    = 4,
    BRUSHDF_RND_POS     = 8,
    BRUSHDF_ROT_DIR     = 0x10,
    BRUSHDF_GAMMA_SIZE  = 0x20,
    BRUSHDF_GAMMA_OPACITY = 0x40,
    BRUSHDF_WATER       = 0x80
};

//! レイヤ描画関連の作業用

struct TILEIMGDRAWINFO
{
    int     nImgW,nImgH,    //!< キャンバスサイズ
            nDotPenSize,    //!< ドットペンの直径pxサイズ
            nColMaskType,   //!< 色マスクタイプ
            nAMaskType;     //!< アルファマスクタイプ

    RGBAFIX15   colDraw,    //!< 描画色
                colMask[6]; //!< 色マスク(a が 0 で無効)

    void (CTileImage::*funcDrawPixel)(int,int,const RGBAFIX15 &);           //!< 点描画関数
    void (CTileImage::*funcColor)(RGBAFIX15 *,const RGBAFIX15 &,LPVOID);    //!< 色処理関数

    CImage8     *pTexture,      //!< テクスチャ（NULLでなし）
                *pBrush,        //!< ブラシ画像 (NULLで通常円形)
                *pDotBrush;     //!< ドットペン用ブラシ形状

    CTileImage  *pimgMask,      //!< レイヤマスク(NULLでなし)
                *pimgSel,       //!< 選択範囲イメージ（NULLでなし）
                *pimgUndo;      //!< アンドゥ用イメージ

    FLAGRECT    rcfDraw;        //!< 描画されたイメージ範囲 (各値はマイナスの場合もあり)
    int         fUndoErr;       //!< アンドゥ時のエラー（0:成功,0bit:イメージタイル確保失敗,1bit:アンドゥ確保失敗）
};

//! キャンバス拡大・回転パラメータ

struct CANVASVIEWPARAM
{
    double  dScale,
            dScaleDiv,  //1.0 / dScale
            dCos,
            dSin,
            dCosRev,    //逆回転
            dSinRev;
};

//! キャンバス描画パラメータ

struct DRAWCANVASINFO
{
    AXRectSize  rcsDst;
    int         nBaseX,
                nBaseY,
                nScrollX,
                nScrollY;
    BOOL        bHRev;
    DWORD       dwExCol;
    CANVASVIEWPARAM *pParam;

    void imgTocanv(double *pX,double *pY,double x,double y) const;
    void getImgToCanvDiff(double *pdst) const;
};

#endif
