/*$
Copyright (C) 2013-2016 Azel.

This file is part of AzPainter.

AzPainter is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

AzPainter is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.
$*/
/*
    フィルタダイアログデータ
*/


namespace filterdat
{

enum TOPFLAGS
{
    PREV_NONE       = 0,
    PREV_INDLG      = 1,
    PREV_CANV_COL   = 2,
    PREV_CANV_COMIC = 3,

    RESET_BTT       = 1<<3,
    SAVE_DAT        = 1<<4,
    GET_CANVASPOS   = 1<<5
};

enum WIDTYPE
{
    WD_BAR = 0,
    WD_CHECK,
    WD_COMBO,
    WD_LABEL,

    WD_DEF_CLIPPING = 0x80,
    WD_DEF_LEVEL    = 0x81,

    WD_END = 255
};

enum BARINITVAL
{
    BARINIT_DPI = 1,
    BARINIT_DRAWCOL_H,
    BARINIT_DRAWCOL_S,
    BARINIT_DRAWCOL_V
};

enum STRID
{
    SID_BRIGHTNESS = 10,
    SID_CONTRAST,
    SID_GAMMA,
    SID_R,
    SID_G,
    SID_B,
    SID_HUE,
    SID_SATURATION,
    SID_THRESHOLD_VAL,
    SID_TYPE,
    SID_GRADATION,  //階調
    SID_STRENGTH,
    SID_ANGLE,
    SID_CANVASPOS_CENTER,
    SID_RADIUS,
    SID_HILIGHT,
    SID_THICKNESS,  //太さ
    SID_COLOR,
    SID_THICKNESS_MIN,
    SID_THICKNESS_MAX,
    SID_INTERVAL_MIN,
    SID_INTERVAL_MAX,
    SID_HORZ_LINE,
    SID_VERT_LINE,
    SID_COL_WIDTH,
    SID_ROW_WIDTH,
    SID_SAME_COLWIDTH,
    SID_LINE_NUM,       //線数
    SID_DENSITY,        //濃度
    SID_DPI,
    SID_ANTIALIAS,
    SID_SIZE,
    SID_USE_ADVCOLOR,
    SID_ANGLE_R,
    SID_ANGLE_G,
    SID_ANGLE_B,
    SID_SAME_ANGLE_R,
    SID_GRAYSCALE,
    SID_AMOUNT,      //量
    SID_DISTANCE,   //距離
    SID_REVERSE,
    SID_LENGTH,
    SID_WIDTH,
    SID_CLIPPING,
    SID_BACKGROUND,
    SID_ZOOM,
    SID_SMOOTH,
    SID_DENT,       //へこみ
    SID_X,
    SID_Y,
    SID_POINTTYPE,
    SID_OPACITY,
    SID_RND_RADIUS_MIN,
    SID_RND_OPACITY_MIN,
    SID_COUNT,
    SID_SRC_CHECKLAYER,
    SID_CUT_SRCIMG,
    SID_FREQUENCY,  //細かさ
    SID_SHARPNESS,  //鮮明さ
    SID_ASPECT_RATIO,
    SID_INTERVAL_RAND,
    SID_THICKNESS_RAND,
    SID_LENGTH_RAND,
    SID_PREVIEW_SIMPLE, //簡易プレビュー
    SID_PREVIEW_RED,
    SID_LENGTH_WAVE,
    SID_TAIL_MIN,
};


//--------- カラー

const BYTE col_brightcont[] = {
    PREV_CANV_COL|RESET_BTT,
    WD_BAR, SID_BRIGHTNESS, 10, 0x01,0x18, 0xff,0x9c, 0,100, 0,0, 0,0,
    WD_BAR, SID_CONTRAST, 10, 0x01,0x18, 0xff,0x9c, 0,100, 0,0, 0,0, WD_END
};

const BYTE col_gamma[] = {
    PREV_CANV_COL|RESET_BTT,
    WD_BAR, SID_GAMMA, 11, 0x01,0x18, 0,10, 0x01,0x90, 0,100, 0,100, 2, WD_END
};

const BYTE col_level[] = {
    PREV_CANV_COL, WD_DEF_LEVEL, WD_END
};

const BYTE col_rgb[] = {
    PREV_CANV_COL|RESET_BTT,
    WD_BAR, SID_R, 11, 0x01,0x18, 0xfc,0x18, 0x03,0xe8, 0,0, 0,0, 1,
    WD_BAR, SID_G, 11, 0x01,0x18, 0xfc,0x18, 0x03,0xe8, 0,0, 0,0, 1,
    WD_BAR, SID_B, 11, 0x01,0x18, 0xfc,0x18, 0x03,0xe8, 0,0, 0,0, 1, WD_END
};

const BYTE col_hsv[] = {
    PREV_CANV_COL|RESET_BTT,
    WD_BAR, SID_HUE, 10, 0x01,0x18, 0xff,0x4c, 0,0xb4, 0,0, 0,0,
    WD_BAR, SID_SATURATION, 10, 0x01,0x18, 0xff,0x9c, 0,100, 0,0, 0,0,
    WD_BAR, SID_BRIGHTNESS, 10, 0x01,0x18, 0xff,0x9c, 0,100, 0,0, 0,0, WD_END
};

const BYTE col_threshold[] = {
    PREV_CANV_COL|RESET_BTT,
    WD_BAR, SID_THRESHOLD_VAL, 11, 0x01,0x18, 0,1, 0x03,0xe8, 0x01,0xf4, 0x01,0xf4, 1, WD_END
};

const BYTE col_threshold_dither[] = {
    PREV_CANV_COL,
    WD_COMBO, SID_TYPE, 3, 5, 0x03,0xe8, WD_END
};

const BYTE col_posterize[] = {
    PREV_CANV_COL,
    WD_BAR, SID_GRADATION, 8, 0x01,0x04, 0,2, 0,128, 0,4, WD_END
};

const BYTE colop_drawcol_rep[] = {
    PREV_CANV_COL|RESET_BTT,
    WD_BAR, SID_HUE, 13, 0x01,0x04, 0,0, 0x01,0x67, 0,0, 0,0, 0, 0, BARINIT_DRAWCOL_H,
    WD_BAR, SID_SATURATION, 13, 0x01,0x04, 0,0, 0,255, 0,0, 0,0, 0, 0, BARINIT_DRAWCOL_S,
    WD_BAR, SID_BRIGHTNESS, 13, 0x01,0x04, 0,0, 0,255, 0,0, 0,0, 0, 0, BARINIT_DRAWCOL_V, WD_END
};

//------ ぼかし

const BYTE blur_blur[] = {
    PREV_INDLG, 0,220, 0,220,
    WD_BAR, SID_RADIUS, 6, 0,100, 0,1, 0,16,
    WD_DEF_CLIPPING, WD_END
};

const BYTE blur_gauss[] = {
    PREV_INDLG, 0,200, 0,200,
    WD_BAR, SID_RADIUS, 6, 0,100, 0,1, 0,20,
    WD_DEF_CLIPPING, WD_END
};

const BYTE blur_motion[] = {
    PREV_INDLG, 0,200, 0,200,
    WD_BAR, SID_RADIUS, 6, 0,100, 0,1, 0,20,
    WD_BAR, SID_ANGLE, 10, 0,180, 0xff,0x4c, 0,180, 0,0, 0,0,
    WD_DEF_CLIPPING, WD_END
};

const BYTE blur_radial[] = {
    PREV_INDLG|GET_CANVASPOS, 0,200, 0,200,
    WD_BAR, SID_STRENGTH, 8, 0,120, 0,1, 0,50, 0,3,
    WD_DEF_CLIPPING,
    WD_LABEL, 0, 2, 0,SID_CANVASPOS_CENTER, WD_END
};

const BYTE blur_lens[] = {
    PREV_INDLG, 0,200, 0,200,
    WD_BAR, SID_RADIUS, 8, 0,120, 0,1, 0,30, 0,3,
    WD_BAR, SID_HILIGHT, 8, 0,120, 0,0, 0,150, 0,20,
    WD_DEF_CLIPPING, WD_END
};

//-------- 描画

const BYTE draw_frame[] = {
    PREV_NONE,
    WD_BAR, SID_THICKNESS, 6, 0,120, 0,1, 0,100,
    WD_COMBO, SID_COLOR, 3, 4, 0x03,0xfc, WD_END
};

const BYTE draw_line[] = {
    PREV_INDLG, 0,230, 0,230,
    WD_BAR, SID_THICKNESS_MIN, 6, 0,180, 0,1, 0,100,
    WD_BAR, SID_THICKNESS_MAX, 6, 0,180, 0,1, 0,100,
    WD_BAR, SID_INTERVAL_MIN, 8, 0,180, 0,1, 0x01,0x90, 0,2,
    WD_BAR, SID_INTERVAL_MAX, 8, 0,180, 0,1, 0x01,0x90, 0,2,
    WD_CHECK, 0, 3, 0,SID_HORZ_LINE, 1,
    WD_CHECK, 0, 2, 0,SID_VERT_LINE,
    WD_COMBO, SID_COLOR, 3, 4, 0x03,0xfc, WD_END
};

const BYTE draw_check[] = {
    PREV_INDLG, 0,220, 0,220,
    WD_BAR, SID_COL_WIDTH, 8, 0,180, 0,2, 0x01,0x90, 0,5,
    WD_BAR, SID_ROW_WIDTH, 8, 0,180, 0,2, 0x01,0x90, 0,5,
    WD_CHECK, 0, 3, 0,SID_SAME_COLWIDTH, 1,
    WD_COMBO, SID_COLOR, 3, 4, 0x03,0xfc, WD_END
};

const BYTE draw_amitone1[] = {
    PREV_INDLG, 0,220, 0,220,
    WD_BAR, SID_LINE_NUM, 11, 0,180, 0,10, 0x0f,0xa0, 0x02,0x58, 0,0, 1,
    WD_BAR, SID_DENSITY, 8, 0,180, 0,1, 0,100, 0,10,
    WD_BAR, SID_ANGLE, 10, 0,180, 0xff,0x4c, 0,0xb4, 0,45, 0,0,
    WD_BAR, SID_DPI, 13, 0,180, 0,1, 0x09,0x60, 0,0, 0,0, 0, 0, 1,
    WD_CHECK, 0, 3, 0,SID_ANTIALIAS, 1,
    WD_COMBO, SID_COLOR, 4, 4, 0x03,0xfc, 2, WD_END
};

const BYTE draw_amitone2[] = {
    PREV_INDLG, 0,220, 0,220,
    WD_BAR, SID_SIZE, 11, 0,180, 0,10, 0x0f,0xa0, 0,50, 0,0, 1,
    WD_BAR, SID_DENSITY, 8, 0,180, 0,1, 0,100, 0,10,
    WD_BAR, SID_ANGLE, 10, 0,180, 0xff,0x4c, 0,0xb4, 0,45, 0,0,
    WD_CHECK, 0, 3, 0,SID_ANTIALIAS, 1,
    WD_COMBO, SID_COLOR, 4, 4, 0x03,0xfc, 2, WD_END
};

const BYTE draw_edge[] = {
    PREV_INDLG, 0,220, 0,220,
    WD_COMBO, SID_TYPE, 3, 2, 0x04,0x42,
    WD_BAR, SID_RADIUS, 6, 0,160, 0,1, 0,100,
    WD_BAR, SID_OPACITY, 8, 0,160, 0,1, 0,100, 0,100,
    WD_COMBO, SID_POINTTYPE, 3, 3, 0x04,0x4c,
    WD_COMBO, SID_COLOR, 3, 4, 0x04,0x56, WD_END
};

const BYTE draw_rndpoint[] = {
    PREV_INDLG, 0,220, 0,220,
    WD_BAR, SID_AMOUNT, 8, 0,180, 0,1, 0x02,0x00, 0,5,
    WD_BAR, SID_RADIUS, 8, 0,180, 0,1, 0,100, 0,2,
    WD_BAR, SID_OPACITY, 8, 0,180, 0,1, 0,100, 0,100,
    WD_BAR, SID_RND_RADIUS_MIN, 8, 0,180, 0,0, 0,100, 0,100,
    WD_BAR, SID_RND_OPACITY_MIN, 8, 0,180, 0,0, 0,100, 0,100,
    WD_COMBO, SID_POINTTYPE, 3, 4, 0x04,0x4c,
    WD_COMBO, SID_COLOR, 3, 4, 0x04,0x56, WD_END
};

const BYTE draw_cloud[] = {
    PREV_INDLG, 0,220, 0,220,
    WD_BAR, SID_FREQUENCY, 8, 0,180, 0,2, 0,200, 0,8,
    WD_BAR, SID_SHARPNESS, 8, 0,180, 0,1, 0,100, 0,60,
    WD_BAR, SID_CONTRAST, 8, 0,180, 0,0, 0,100, 0,20,
    WD_COMBO, SID_COLOR, 3, 3, 0x04,0x60, WD_END
};

//------- ピクセレート

const BYTE pix_mozaic[] = {
    PREV_INDLG, 0,220, 0,220,
    WD_BAR, SID_SIZE, 6, 0,120, 0,2, 0,100,
    WD_DEF_CLIPPING, WD_END
};

const BYTE pix_crystal[] = {
    PREV_INDLG, 0,220, 0,220,
    WD_BAR, SID_SIZE, 6, 0,140, 0,5, 0,200,
    WD_CHECK, 0, 2, 0,SID_USE_ADVCOLOR,
    WD_DEF_CLIPPING, WD_END
};

const BYTE pix_halftone[] = {
    PREV_INDLG, 0,220, 0,220,
    WD_BAR, SID_SIZE, 11, 0,180, 0,10, 0x07,0xd0, 0,50, 0,0, 1,
    WD_BAR, SID_ANGLE_R, 10, 0,180, 0xff,0x4c, 0,0xb4, 0,15, 0,0,
    WD_BAR, SID_ANGLE_G, 10, 0,180, 0xff,0x4c, 0,0xb4, 0,75, 0,0,
    WD_BAR, SID_ANGLE_B, 10, 0,180, 0xff,0x4c, 0,0xb4, 0,0, 0,0,
    WD_CHECK, 0, 2, 0,SID_SAME_ANGLE_R,
    WD_CHECK, 0, 3, 0,SID_ANTIALIAS, 1,
    WD_CHECK, 0, 2, 0,SID_GRAYSCALE, WD_END
};

//------ 輪郭

const BYTE edge_sharp[] = {
    PREV_INDLG, 0,220, 0,220,
    WD_BAR, SID_STRENGTH, 8, 0,120, 0,1, 0,50, 0,3,
    WD_DEF_CLIPPING, WD_END
};

const BYTE edge_unsharpmask[] = {
    PREV_INDLG, 0,220, 0,220,
    WD_BAR, SID_RADIUS, 8, 0,180, 0,1, 0,20, 0,1,
    WD_BAR, SID_AMOUNT, 8, 0,180, 0,1, 0x01,0x2c, 0,50,
    WD_DEF_CLIPPING, WD_END
};

const BYTE edge_highpass[] = {
    PREV_INDLG, 0,220, 0,220,
    WD_BAR, SID_RADIUS, 6, 0,120, 0,1, 0,20,
    WD_DEF_CLIPPING, WD_END
};

//------- 効果

const BYTE eff_glow[] = {
    PREV_INDLG, 0,220, 0,220,
    WD_BAR, SID_BRIGHTNESS, 8, 0,180, 0,1, 0,100, 0,30,
    WD_BAR, SID_RADIUS, 8, 0,180, 0,1, 0,20, 0,3,
    WD_BAR, SID_AMOUNT, 8, 0,180, 0,1, 0,100, 0,100,
    WD_DEF_CLIPPING, WD_END
};

const BYTE eff_rgbshift[] = {
    PREV_INDLG, 0,220, 0,220,
    WD_COMBO, SID_TYPE, 3, 3, 0x04,0x06,
    WD_BAR, SID_DISTANCE, 8, 0,180, 0,1, 0,100, 0,3,
    WD_DEF_CLIPPING, WD_END
};

const BYTE eff_oilpaint[] = {
    PREV_INDLG, 0,220, 0,220,
    WD_BAR, SID_RADIUS, 8, 0,100, 0,1, 0,8, 0,2,
    WD_DEF_CLIPPING, WD_END
};

const BYTE eff_emboss[] = {
    PREV_INDLG, 0,220, 0,220,
    WD_BAR, SID_STRENGTH, 6, 0,100, 0,1, 0,16,
    WD_COMBO, SID_TYPE, 3, 3, 0x04,0x06,
    WD_CHECK, 0, 2, 0,SID_REVERSE,
    WD_CHECK, 0, 3, 0,SID_GRAYSCALE, 1,
    WD_DEF_CLIPPING, WD_END
};

const BYTE eff_noise[] = {
    PREV_INDLG, 0,220, 0,220,
    WD_BAR, SID_AMOUNT, 8, 0,180, 0,1, 0x01,0x00, 0,20,
    WD_CHECK, 0, 3, 0,SID_GRAYSCALE, 1, WD_END
};

const BYTE eff_diffusion[] = {
    PREV_INDLG, 0,220, 0,220,
    WD_BAR, SID_RADIUS, 6, 0,180, 0,1, 0,50,
    WD_DEF_CLIPPING, WD_END
};

const BYTE eff_scratch[] = {
    PREV_INDLG, 0,220, 0,220,
    WD_BAR, SID_LENGTH, 8, 0,180, 0,2, 0,50, 0,10,
    WD_BAR, SID_ANGLE, 10, 0,180, 0xff,0x4c, 0,0xb4, 0,45, 0,0,
    WD_DEF_CLIPPING, WD_END
};

const BYTE eff_median[] = {
    PREV_INDLG, 0,220, 0,220,
    WD_BAR, SID_RADIUS, 6, 0,50, 0,1, 0,3,
    WD_COMBO, SID_TYPE, 4, 3, 0x04,0x10, 1,
    WD_DEF_CLIPPING, WD_END
};

const BYTE eff_blurring[] = {
    PREV_INDLG, 0,220, 0,220,
    WD_BAR, SID_DISTANCE, 8, 0,180, 0,1, 0,60, 0,4,
    WD_DEF_CLIPPING, WD_END
};

const BYTE trans_wave[] = {
    PREV_INDLG, 0,220, 0,220,
    WD_BAR, SID_AMOUNT, 8, 0,180, 0,1, 0,50, 0,10,
    WD_BAR, SID_WIDTH, 11, 0,180, 0,1, 0x01,0xf4, 0,40, 0,0, 1,
    WD_COMBO, SID_TYPE, 4, 3, 0x04,0x1a, 2,
    WD_COMBO, SID_CLIPPING, 4, 3, 0x04,0x24, 1, WD_END
};

const BYTE trans_ripple[] = {
    PREV_INDLG|GET_CANVASPOS, 0,220, 0,220,
    WD_BAR, SID_FREQUENCY, 8, 0,180, 0,1, 0,100, 0,17,
    WD_BAR, SID_AMOUNT, 8, 0,180, 0,1, 0,200, 0,50,
    WD_DEF_CLIPPING,
    WD_LABEL, 0, 2, 0,SID_CANVASPOS_CENTER, WD_END
};

const BYTE trans_polar[] = {
    PREV_NONE,
    WD_COMBO, SID_TYPE, 3, 2, 0x04,0x2e,
    WD_COMBO, SID_BACKGROUND, 3, 3, 0x04,0x38, WD_END
};

const BYTE trans_radialshift[] = {
    PREV_INDLG|GET_CANVASPOS, 0,220, 0,220,
    WD_BAR, SID_LENGTH, 8, 0,180, 0,1, 0,150, 0,10,
    WD_LABEL, 0, 2, 0,SID_CANVASPOS_CENTER, WD_END
};

const BYTE trans_swirl[] = {
    PREV_INDLG|GET_CANVASPOS, 0,220, 0,220,
    WD_BAR, SID_AMOUNT, 8, 0,180, 0,1, 0,200, 0,20,
    WD_BAR, SID_ZOOM, 11, 0,180, 0,1, 0x01,0x2c, 0,100, 0,100, 2,
    WD_COMBO, SID_BACKGROUND, 4, 4, 0x04,0x38, 1,
    WD_LABEL, 0, 2, 0,SID_CANVASPOS_CENTER, WD_END
};

//------ 漫画用

const BYTE comic_concline[] = {
    PREV_CANV_COMIC|GET_CANVASPOS|SAVE_DAT|RESET_BTT,
    WD_BAR, SID_RADIUS, 12, 0,200, 0,10, 0x13,0x88, 0,200, 0,0, 0, 'a',    //半径(10-5000)
    WD_BAR, SID_ASPECT_RATIO, 12, 0,200, 0xfc,0x18, 0x03,0xe8, 0,0, 0,0, 3, 'b',  //縦横比
    WD_BAR, SID_DENSITY, 12, 0,200, 0,2, 0x01,0x2c, 0,15, 0,0, 0, 'c',    //密度(2-300)
    WD_BAR, SID_INTERVAL_RAND, 12, 0,200, 0,0, 0,99, 0,100, 0,0, 0, 'd',  //間隔ランダム(0-99)
    WD_BAR, SID_THICKNESS, 12, 0,200, 0,2, 0x03,0xe8, 0,25, 0,0, 1, 'e',    //太さ(0.2-100.0)
    WD_BAR, SID_THICKNESS_RAND, 12, 0,200, 0,0, 0x03,0xe8, 0,0, 0,0, 1, 'f',
    WD_BAR, SID_LENGTH, 12, 0,200, 0,1, 0x03,0xe8, 0x01,0xf4, 0,0, 1, 'g', //長さ(0.1-100.0)
    WD_BAR, SID_LENGTH_RAND, 12, 0,200, 0,0, 0x03,0xe8, 0,200, 0,0, 1, 'h',   //長さランダム(0.0-100.0)
    WD_COMBO, SID_TYPE, 5, 3, 0x04,0x6a, 0, 'i',  //描画タイプ
    WD_CHECK, 0, 4, 0,SID_PREVIEW_SIMPLE, 1, 'j',
    WD_CHECK, 0, 4, 0,SID_PREVIEW_RED, 1, 'k',
    WD_LABEL, 0, 2, 0,SID_CANVASPOS_CENTER, WD_END
};

const BYTE comic_flash[] = {
    PREV_CANV_COMIC|GET_CANVASPOS|SAVE_DAT|RESET_BTT,
    WD_BAR, SID_RADIUS, 12, 0,200, 0,10, 0x0f,0xa0, 0,200, 0,0, 0, 'a',
    WD_BAR, SID_ASPECT_RATIO, 12, 0,200, 0xfc,0x18, 0x03,0xe8, 0,0, 0,0, 3, 'b',
    WD_BAR, SID_DENSITY, 12, 0,200, 0,2, 0x01,0x2c, 0,100, 0,0, 0, 'c',
    WD_BAR, SID_INTERVAL_RAND, 12, 0,200, 0,0, 0,99, 0,20, 0,0, 0, 'd',
    WD_BAR, SID_THICKNESS, 12, 0,200, 0,2, 0x03,0xe8, 0,40, 0,0, 1, 'e',
    WD_BAR, SID_THICKNESS_RAND, 12, 0,200, 0,0, 0x03,0xe8, 0,30, 0,0, 1, 'f',
    WD_BAR, SID_LENGTH, 12, 0,200, 0,1, 0x03,0xe8, 0x01,0x5e, 0,0, 1, 'g',
    WD_BAR, SID_LENGTH_RAND, 12, 0,200, 0,0, 0x03,0xe8, 0,200, 0,0, 1, 'h',
    WD_COMBO, SID_TYPE, 5, 3, 0x04,0x6a, 0, 'i',
    WD_CHECK, 0, 4, 0,SID_PREVIEW_SIMPLE, 1, 'j',
    WD_CHECK, 0, 4, 0,SID_PREVIEW_RED, 1, 'k',
    WD_LABEL, 0, 2, 0,SID_CANVASPOS_CENTER, WD_END
};

const BYTE comic_popupflash[] = {
    PREV_CANV_COMIC|GET_CANVASPOS|SAVE_DAT|RESET_BTT,
    WD_BAR, SID_RADIUS, 12, 0,200, 0,10, 0x0f,0xa0, 0,130, 0,0, 0, 'a',
    WD_BAR, SID_ASPECT_RATIO, 12, 0,200, 0xfc,0x18, 0x03,0xe8, 0,0, 0,0, 3, 'b',
    WD_BAR, SID_DENSITY, 12, 0,200, 0,2, 0x01,0x2c, 0,80, 0,0, 0, 'c',
    WD_BAR, SID_INTERVAL_RAND, 12, 0,200, 0,0, 0,99, 0,20, 0,0, 0, 'd',
    WD_BAR, SID_THICKNESS, 12, 0,200, 0,2, 0x03,0xe8, 0,30, 0,0, 1, 'e',
    WD_BAR, SID_THICKNESS_RAND, 12, 0,200, 0,0, 0x03,0xe8, 0,20, 0,0, 1, 'f',
    WD_BAR, SID_LENGTH, 12, 0,200, 0,1, 0x03,0xe8, 0,250, 0,0, 1, 'g',
    WD_BAR, SID_LENGTH_RAND, 12, 0,200, 0,0, 0x03,0xe8, 0x01,0x2c, 0,0, 1, 'h',
    WD_COMBO, SID_TYPE, 5, 3, 0x04,0x6a, 0, 'i',
    WD_CHECK, 0, 4, 0,SID_PREVIEW_SIMPLE, 1, 'j',
    WD_CHECK, 0, 4, 0,SID_PREVIEW_RED, 1, 'k',
    WD_LABEL, 0, 2, 0,SID_CANVASPOS_CENTER, WD_END
};

const BYTE comic_uniflash[] = {
    PREV_CANV_COMIC|GET_CANVASPOS|SAVE_DAT|RESET_BTT,
    WD_BAR, SID_RADIUS, 12, 0,200, 0,10, 0x0f,0xa0, 0,160, 0,0, 0, 'a',
    WD_BAR, SID_ASPECT_RATIO, 12, 0,200, 0xfc,0x18, 0x03,0xe8, 0,0, 0,0, 3, 'b',
    WD_BAR, SID_DENSITY, 12, 0,200, 0,2, 0x01,0x2c, 0,110, 0,0, 0, 'c',
    WD_BAR, SID_INTERVAL_RAND, 12, 0,200, 0,0, 0,99, 0,0, 0,0, 0, 'd',
    WD_BAR, SID_THICKNESS, 12, 0,200, 0,2, 0x03,0xe8, 0,30, 0,0, 1, 'e',
    WD_BAR, SID_THICKNESS_RAND, 12, 0,200, 0,0, 0x03,0xe8, 0,0, 0,0, 1, 'f',
    WD_BAR, SID_LENGTH, 12, 0,200, 0,1, 0x03,0xe8, 0x01,0x2c, 0,0, 1, 'g',
    WD_BAR, SID_LENGTH_RAND, 12, 0,200, 0,0, 0x03,0xe8, 0,0, 0,0, 1, 'h',
    WD_COMBO, SID_TYPE, 5, 3, 0x04,0x6a, 0, 'i',
    WD_CHECK, 0, 4, 0,SID_PREVIEW_SIMPLE, 1, 'j',
    WD_CHECK, 0, 4, 0,SID_PREVIEW_RED, 1, 'k',
    WD_LABEL, 0, 2, 0,SID_CANVASPOS_CENTER, WD_END
};

const BYTE comic_uniflash_wave[] = {
    PREV_CANV_COMIC|GET_CANVASPOS|SAVE_DAT|RESET_BTT,
    WD_BAR, SID_RADIUS, 12, 0,200, 0,10, 0x0f,0xa0, 0,160, 0,0, 0, 'a',
    WD_BAR, SID_ASPECT_RATIO, 12, 0,200, 0xfc,0x18, 0x03,0xe8, 0,0, 0,0, 3, 'b',
    WD_BAR, SID_DENSITY, 12, 0,200, 0,2, 0x01,0x2c, 0,30, 0,0, 0, 'c',
    WD_BAR, SID_LENGTH_WAVE, 12, 0,200, 0,1, 0x03,0xe8, 0,200, 0,0, 1, 'd', //波の長さ
    WD_BAR, SID_THICKNESS, 12, 0,200, 0,2, 0x03,0xe8, 0,15, 0,0, 1, 'e',
    WD_BAR, SID_LENGTH, 12, 0,200, 0,1, 0x03,0xe8, 0x01,0x2c, 0,0, 1, 'f',
    WD_BAR, SID_TAIL_MIN, 12, 0,200, 0,0, 0,100, 0,0, 0,0, 0, 'g',    //抜きの最小(0-100)
    WD_COMBO, SID_TYPE, 5, 3, 0x04,0x6a, 0, 'h',
    WD_CHECK, 0, 4, 0,SID_PREVIEW_SIMPLE, 1, 'i',
    WD_CHECK, 0, 4, 0,SID_PREVIEW_RED, 1, 'j',
    WD_LABEL, 0, 2, 0,SID_CANVASPOS_CENTER, WD_END
};

//------ その他

const BYTE etc_3Dbutton[] = {
    PREV_NONE,
    WD_BAR, SID_WIDTH, 8, 0,100, 0,1, 0,100, 0,6,
    WD_CHECK, 0, 2, 0,SID_SMOOTH,
    WD_CHECK, 0, 2, 0,SID_DENT, WD_END
};

const BYTE etc_shift[] = {
    PREV_NONE,
    WD_BAR, SID_X, 10, 0x01,0x18, 0xfc,0x18, 0x03,0xe8, 0,0, 0,0,
    WD_BAR, SID_Y, 10, 0x01,0x18, 0xfc,0x18, 0x03,0xe8, 0,0, 0,0, WD_END
};

const BYTE etc_hemming[] = {
    PREV_INDLG, 0,220, 0,220,
    WD_BAR, SID_COUNT, 6, 0,120, 0,1, 0,20,
    WD_COMBO, SID_COLOR, 3, 4, 0x03,0xfc,
    WD_CHECK, 0, 2, 0,SID_SRC_CHECKLAYER,
    WD_CHECK, 0, 2, 0,SID_CUT_SRCIMG, WD_END
};

const BYTE etc_antialiasing[] = {
    PREV_INDLG, 0,220, 0,220,
    WD_BAR, SID_STRENGTH, 8, 0,120, 0,1, 0,100, 0,80, WD_END
};

};
