/*$
Copyright (C) 2013-2016 Azel.

This file is part of AzPainter.

AzPainter is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

AzPainter is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.
$*/

#ifndef _AZPT_DRAW_MAIN_H_
#define _AZPT_DRAW_MAIN_H_

class AXPoint;
class AXString;
class AXRectSize;
class CProgressDlg;
class CTileImage;
union RGBFIX15;

namespace draw
{

void initAfterConfig();
void initAfterShow();

BOOL newImage(int w,int h,int dpi,BOOL bAddLayer);
BOOL errLoadImage();
int loadImage(const AXString &filename,CProgressDlg *pdlg);

void setUndoChangeOff();
void setUndoMaxCnt(int cnt);
BOOL isChangeImage();
BOOL undoRedo(BOOL bRedo,LPINT pType,AXRectSize *prcs);

CTileImage *getCurImg();
CTileImage *allocTileImage(int coltype);
void getCurImgDrawRect(AXRect *prc);
void blendImage();
BOOL getPixelBlendColor(RGBFIX15 *pdst,int x,int y);
BOOL loadOptTexImg();

void changeFile();
void changeImageSize();
BOOL changeCanvasImgSize(int w,int h);
void changeTool(int no);
void changeToolSubType(int no);
void changeCanvasWinSize(BOOL bReDraw,AXPoint *pct=NULL);
void changeScale(int scale,BOOL bRedraw=TRUE,BOOL bHiQuality=TRUE,BOOL bScrReset=TRUE);
void changeScaleToolUpDown(BOOL bDown);
void changeRotate(int angle,BOOL bRedraw=TRUE,BOOL bHiQuality=TRUE,BOOL bScrReset=TRUE);
void changeScrollPos(const AXPoint &pt,BOOL bReDraw);
void changeScaleAndRotate(BOOL bRedraw);
void changeDrawCol(DWORD col);
void changeColMaskColor(int no,DWORD col);

void scaleUpDown(BOOL bUp);
void canvasHRev();
void resetCanvasView();
void toggleDrawCol();
BOOL resizeCanvas(int w,int h,int topx,int topy);
BOOL scaleCanvas(int w,int h,int dpi,int type);

void setScroll_default();
void setScroll_reset();

BOOL selAllocArray();
void selFreeEmpty();
BOOL isSelExist();
void selRelease(BOOL bUpdate=TRUE);
void selAll();
void selInverse();
void selPaintErase(BOOL bErase);
void selCopy(BOOL bCut);
void selPaste();
void selInflateDeflate(BOOL bInflate);

};

#endif
