/*$
Copyright (C) 2013-2016 Azel.

This file is part of AzPainter.

AzPainter is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

AzPainter is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.
$*/

#ifndef _AZPT_DRAW_LAYER_H_
#define _AZPT_DRAW_LATER_H_

class CLayerItem;

namespace draw
{

void layer_changeCurrent(CLayerItem *p);
void layer_revShow(CLayerItem *p);
void layer_revFolderExpand(CLayerItem *p);
void layer_changeBlendMode(int no);
void layer_changeOpacity(int opacity);
void layer_revLockFlag(CLayerItem *p);
void layer_revPaintFlag(CLayerItem *p);
void layer_revLinkFlag(CLayerItem *p);
void layer_revCheckFlag(CLayerItem *p);
void layer_changeLayerMask(CLayerItem *p,int type);
void layer_changeCol(CLayerItem *p,DWORD col);

void layer_new(const AXString &strName,int nBlendMode,int nColType,DWORD dwCol);
void layer_newFolder(const AXString &strName);
BOOL layer_fromImg(const AXString &filename);
void layer_copy();
void layer_delete(BOOL bUpdate=TRUE);
void layer_clear();
BOOL layer_changeColType(CLayerItem *pItem,int type,BOOL bLum);
void layer_combine(BOOL bDrop);
BOOL layer_combinesome(int type,BOOL bNewLayer,int coltype);
BOOL layer_unite();
void layer_revHorzVert(BOOL bHorz);
void layer_rotate90(BOOL bLeft);
void layer_moveDND(CLayerItem *pDst,int type);
void layer_moveUpDown(BOOL bUp);
void layer_showAll(int type);
void layer_showCheckRev();
void layer_showToggleNormal();
void layer_curSelUpDown(BOOL bUp);

};

#endif
