/*$
Copyright (C) 2013-2016 Azel.

This file is part of AzPainter.

AzPainter is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

AzPainter is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.
$*/

#ifndef _AZPT_DRAW_CALC_H_
#define _AZPT_DRAW_CALC_H_

class AXSize;
class AXRect;
class AXRectSize;
struct FLAGRECT;
struct DRECT;
struct DPOINT;

namespace draw
{

BOOL unionRectSize(AXRectSize *pdst,const AXRectSize &src);
BOOL getImgRect(AXRectSize *prcs,const FLAGRECT &src);
BOOL adjustImgRect(AXRectSize *prcs,int x1,int y1,int x2,int y2);
BOOL winToimgRect(AXRectSize *pdst,const AXRectSize &rcs);

void getPtLine45(AXPoint *pdst,const AXPoint &st);
void getDrawLineRect(DRECT *prc);
void getDrawBoxPoint(DPOINT *pdst);
void getDrawBox(AXRectSize *prcs);
BOOL calcMoveOffset(CTileImage *pimg,BOOL bHorz,BOOL bVert,AXPoint *pptMove);

int getScaleWithinCanvas();
void getCanvasScrollMax(AXSize *psize);
int getScaleUpDown(BOOL bUp);

};

#endif
