/*$
Copyright (C) 2013-2016 Azel.

This file is part of AzPainter.

AzPainter is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

AzPainter is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.
$*/

#ifndef _AZPT_DRAWVIEW_H_
#define _AZPT_DRAWVIEW_H_

#include "struct.h"

namespace draw
{

struct VIEW
{
    int     nScale,         //!< キャンバス倍率 (0.1単位:10=1.0)
            nAngle;         //!< キャンバス回転角度 (-18000〜+18000。0.01単位:100=1.0)
    BOOL    bHRev;          //!< キャンバス左右反転表示

    AXSize  szCanvas;       //!< CCanvasWinArea の表示部分サイズ
    AXPoint ptBaseImg,      //!< イメージ座標での表示基準位置（回転の中心位置）
            ptScr;          //!< キャンバス内のスクロール位置

    CANVASVIEWPARAM param;  //!< 倍率・回転の計算値

    RGBFIX15    colImgBk,       //!< イメージ背景色
                colBkCheck[2];  //!< チャック柄背景色

    //----------

    VIEW();

    void calcParam();
    void winToimg(double *pX,double *pY,double x,double y);
    void winToimg(AXPoint *pdst,double x,double y);
    void imgTowin(AXPoint *pdst,int x,int y);
    void getImgPosCanvasMid(AXPoint *pdst);
    BOOL imgTowinRect(AXRectSize *pdst,const AXRectSize &src);
    void rectInCanvas(AXRect *prc);
    BOOL rectInCanvas(AXRectSize *pdst,const AXRect &rcSrc);
    void getMoveDst(AXPoint *pDst,const AXPoint &src);
};

};

#endif
