/*$
Copyright (C) 2013-2016 Azel.

This file is part of AzPainter.

AzPainter is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

AzPainter is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.
$*/

#ifndef _AZPT_TILEIMAGEA16_H_
#define _AZPT_TILEIMAGEA16_H_

#include "CTileImage.h"

class CTileImageA16:public CTileImage
{
protected:
    virtual void _getPixelCol_tile(RGBAFIX15 *pdst,void *pTile,int x,int y) const;
    virtual void *_getPixelBuf_tile(void *pTile,int x,int y) const;
    virtual void _setPixel_buf(void *pbuf,int x,int y,const RGBAFIX15 &col);
    virtual BOOL _isTransparentTile(void *pTile);
    virtual void  _blendTile_RGB16(CImageRGB16 *pimgDst,void *pTile,int dx,int dy,int opacity,const AXRect &rcClip,void (*funcCol)(RGBAFIX15 *,const RGBFIX15 &));
    virtual void _reverseHorz_tile(void *pTile);
    virtual void _reverseVert_tile(void *pTile);
    virtual void _rotateLeft_tile(void *pTile);
    virtual void _rotateRight_tile(void *pTile);
    virtual void _getBufRGBA_tile(RGBAFIX15 *pDst,const void *pTile) const;
    virtual void _setFromBufRGBA_tile(void *pTile,const RGBAFIX15 *pSrc,BOOL bLum);

public:
    CTileImageA16();

    virtual void getSaveTileBuf(LPBYTE pDst,void *pTile);
    virtual void setSaveTileBuf(void *pTile,LPBYTE pSrc);
};

#endif
