/*$
Copyright (C) 2013-2016 Azel.

This file is part of AzPainter.

AzPainter is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

AzPainter is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.
$*/

#ifndef _AZPT_SELIMGDLG_H_
#define _AZPT_SELIMGDLG_H_

#include "AXDialog.h"
#include "AXString.h"

class AXTreeView;
class AXListBox;
class AXTreeViewItem;
class CImgPrev;
class CImage8;


class CSelImgDlg:public AXDialog
{
public:
    enum
    {
        TYPE_OPT_TEXTURE,
        TYPE_BRUSH_TEXTURE,
        TYPE_BRUSH_BRUSH
    };

protected:
    enum
    {
        WID_TREE = 100,
        WID_LIST,

        TREEPF_READ = 1,
        TREEPF_USER = 2
    };

    int         m_nType,
                m_bUserDir;
    AXString    *m_pstrRet,
                m_strDir,
                m_strDirPath;

    AXTreeView  *m_pTree;
    AXListBox   *m_pList;
    CImgPrev    *m_pPrev;

protected:
    void _end(BOOL bOK);
    void _setInitPath();
    void _getRootDir(AXString *pStr,BOOL bUser);
    BOOL _setPrevImg(const AXString &filename);

    void _treeSelChange();
    void _initTree();
    void _addTreeDir(AXTreeViewItem *pParent,const AXString &path);

    void _listChangeSel();
    void _setFileList();

public:
    CSelImgDlg(AXWindow *pOwner,int type,AXString *pstrRet);

    virtual BOOL onNotify(AXWindow *pwin,UINT uNotify,ULONG lParam);
};

#endif
