/*$
Copyright (C) 2013-2016 Azel.

This file is part of AzPainter.

AzPainter is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

AzPainter is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.
$*/
//[subwidget1.cpp]

#ifndef _AZPT_SELIMGBAR_H_
#define _AZPT_SELIMGBAR_H_

#include "AXWindow.h"
#include "AXString.h"

class CSelImgBar:public AXWindow
{
public:
    enum
    {
        TYPE_OPT_TEXTURE,
        TYPE_BRUSH_TEXTURE,
        TYPE_BRUSH_BRUSH
    };

protected:
    AXString    m_strName,
                m_strNameSrc;
    int         m_nType;

    void _dialog();
    void _runMenu();

public:
    CSelImgBar(AXWindow *pParent,UINT uStyle,UINT uLayoutFlags,UINT uItemID,DWORD dwPadding,int type);

    const AXString& getName() const { return m_strNameSrc; }
    void setName(const AXString &name);

    virtual void calcDefSize();
    virtual BOOL onPaint(AXHD_PAINT *phd);
    virtual BOOL onButtonDown(AXHD_MOUSE *phd);
};

#endif
