/*$
Copyright (C) 2013-2016 Azel.

This file is part of AzPainter.

AzPainter is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

AzPainter is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.
$*/
//[subwidget1.cpp]

#ifndef _AZPT_PRESSCURVE_H_
#define _AZPT_PRESSCURVE_H_

#include "AXWindow.h"
#include "AXImage.h"

class CPressCurve:public AXWindow
{
protected:
    AXImage m_img;
    int     m_nVal;

protected:
    void _changePos(int x,int y);
    void _draw();

public:
    CPressCurve(AXWindow *pParent,UINT uItemID,int size);

    int getVal() { return m_nVal; }
    void setVal(int val);

    virtual BOOL onPaint(AXHD_PAINT *phd);
    virtual BOOL onButtonDown(AXHD_MOUSE *phd);
    virtual BOOL onButtonUp(AXHD_MOUSE *phd);
    virtual BOOL onMouseMove(AXHD_MOUSE *phd);
};

#endif
