/*$
Copyright (C) 2013-2016 Azel.

This file is part of AzPainter.

AzPainter is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

AzPainter is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.
$*/

#ifndef _AZPT_POLYGONPAINT_H_
#define _AZPT_POLYGONPAINT_H_

#include "AXMem.h"

class CPolygonPaint
{
protected:
    typedef struct
    {
        double x,y;
    }POSDAT;

    typedef struct
    {
        int x,bUpper;
    }EDGEDAT;

protected:
    AXMemAuto   m_memPos,
                m_memEdge;
    AXMem       m_memXbuf;

    int	    m_nPosCnt,
            m_nEdgeCnt,
            m_nMinY,
            m_nMaxY,
            m_nMinX,
            m_nMaxX,
            m_nWidth,
            m_nNowPos,
            m_nNowEdgeCnt;

protected:
    BOOL _addEdge(int x,BOOL bUpper);
    BOOL _findIntersection(double y);
    void _sortEdge();

public:
    CPolygonPaint();

    int getPosCnt() { return m_nPosCnt; }
	int getMinY() { return m_nMinY; }
	int getMaxY() { return m_nMaxY; }
	int getMinX() { return m_nMinX; }
	int getWidth() { return m_nWidth; }
	LPBYTE getXbuf() { return (LPBYTE)m_memXbuf; }

    void free();
    BOOL alloc(int cnt);
    BOOL add(double x,double y);
    void endPos();

    BOOL beginDraw(BOOL bAntiAlias);
    BOOL setXbuf_AA(int ypos);
    BOOL findIntersectionInt(int y);
    BOOL getNextLine(int *pX1,int *pX2);
};

#endif
