/*$
Copyright (C) 2013-2016 Azel.

This file is part of AzPainter.

AzPainter is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

AzPainter is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.
$*/

#ifndef _AZPT_PERLINNOISE_H_
#define _AZPT_PERLINNOISE_H_

#include "AXMem.h"

class AXRand;

class CPerlinNoise
{
protected:
    AXMem   m_mem;
    double  m_freq,
            m_persis;

protected:
    double _noise(double x,double y);
    double _lerp(double t,double a,double b);
    double _grad(int hash,double x,double y);

public:
    BOOL init(AXRand *prand,double freq,double persis);
    double noise(double x,double y);
};

#endif
