/*$
Copyright (C) 2013-2016 Azel.

This file is part of AzPainter.

AzPainter is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

AzPainter is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.
$*/

#ifndef _AZPT_PALETTE_H_
#define _AZPT_PALETTE_H_

#include "AXDef.h"

class AXString;

class CPalette
{
public:
    enum{ MAXCNT = 4096 };

protected:
    LPDWORD m_pBuf;
    int     m_nCnt;

protected:
    BOOL _resize(int cnt);

public:
    CPalette();
    ~CPalette();

    LPDWORD getBuf() { return m_pBuf; }
    int getCnt() { return m_nCnt; }
    DWORD getCol(int no) { return m_pBuf[no]; }

    void free();
    BOOL alloc(int cnt);
    void resize(int cnt);
    void clearWhite();

    void setCol(int no,DWORD col);
    void insertCol(int no,DWORD col);
    void deleteCol(int no);
    void moveCol(int srcno,int dstno);
    void gradient(int no1,int no2);

    BOOL createFromImg(const AXString &filename);
    BOOL loadFile(const AXString &filename);
    BOOL loadAPL(const AXString &filename);
    BOOL loadACO(const AXString &filename);
    BOOL saveAPL(const AXString &filename);
    BOOL saveACO(const AXString &filename);
};

//

class CPaletteList
{
public:
    enum{ CNT = 4 };

    CPalette    m_pal[CNT];

    static CPaletteList *m_pSelf;

protected:
    BOOL    m_bUpdate;

public:
    CPaletteList();

    void updateON() { m_bUpdate = TRUE; }

    void setDefault();
    void loadFile(const AXString &filename);
    void saveFile(const AXString &filename);
};

#define PALETTE (CPaletteList::m_pSelf)

#endif
