/*$
Copyright (C) 2013-2016 Azel.

This file is part of AzPainter.

AzPainter is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

AzPainter is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.
$*/

#ifndef _AZPT_LAYERWINAREA_H_
#define _AZPT_LAYERWINAREA_H_

#include "AXWindow.h"

class CXImage;
class AXScrollBar;
class CLayerItem;

class CLayerWinArea:public AXWindow
{
public:
    enum
    {
        ITEM_H   = 36,
        MINWIDTH = 140,
        DEPTHW   = 12,

        BTTSIZE = 13,
        CKSHOW_X = 3,
        CKSHOW_Y = 3,
        CKUNDER_X = 21,
        CKUNDER_Y = 19,
        COLAREA_X = 3,

        DRAGF_BEGINMOVE = 1,
        DRAGF_MOVE
    };

protected:
    AXScrollBar *m_pScrV;
    CXImage     *m_pimg;

    int     m_fDrag,
            m_nDragY,
            m_nDragDstType;
    CLayerItem  *m_pDragDst;

protected:
    void _drawOne(CLayerItem *p,int ytop,BOOL bRedraw);
    void _drawDND(BOOL bErase);
    CLayerItem *_onDown(int x,int y,UINT state,BOOL bDblClk,int *pCmd);
    CLayerItem *_getItem(int y,int *pTopY=NULL);
    int _getItemTopY(CLayerItem *pItem);
    void _runRMenu(CLayerItem *pItem,int x,int y);

public:
    CLayerWinArea(AXWindow *pParent);
    virtual ~CLayerWinArea();

    void setScrollBar(AXScrollBar *p) { m_pScrV = p; }

    void setScrollInfo();
    void draw();
    void draw(CLayerItem *p);
    void updateShowCur();

    virtual BOOL onSize();
    virtual BOOL onPaint(AXHD_PAINT *phd);
    virtual BOOL onButtonDown(AXHD_MOUSE *phd);
    virtual BOOL onButtonUp(AXHD_MOUSE *phd);
    virtual BOOL onMouseMove(AXHD_MOUSE *phd);
    virtual BOOL onDblClk(AXHD_MOUSE *phd);
    virtual BOOL onMouseWheel(AXHD_MOUSE *phd,BOOL bUp);
    virtual BOOL onTimer(UINT uTimerID,ULONG lParam);
};

#endif
