/*$
Copyright (C) 2013-2016 Azel.

This file is part of AzPainter.

AzPainter is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

AzPainter is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.
$*/

#ifndef _AZPT_LAYERLIST_H_
#define _AZPT_LAYERLIST_H_

#include "AXTree.h"
#include "AXString.h"

class CLayerItem;
class CTileImage;
class CProgressDlg;
struct TILEIMGINFO;
struct FLAGRECT;


class CLayerList:public AXTree
{
protected:
    int     m_nCnt,
            m_nViewCnt;

protected:
    CLayerItem *_allocItem();
    CTileImage *_allocImg(int coltype);

public:
    CLayerList();

    int getCnt() { return m_nCnt; }
    int getViewCnt() { return m_nViewCnt; }
    CLayerItem *getTopItem() { return (CLayerItem *)m_pTop; }
    CLayerItem *getBottomItem() { return (CLayerItem *)m_pBottom; }

    void clearItem();

    CLayerItem *addLayer(CLayerItem *pIns);
    CLayerItem *addLayer(CLayerItem *pIns,int coltype,const TILEIMGINFO *pinfo,int w,int h);
    CLayerItem *addLayerFromNo(int pno,int no);
    CLayerItem *addNewCanvasLayer(int w,int h);
    CLayerItem *copyLayer(CLayerItem *pItem);
    void deleteLayer(CLayerItem *p);

    BOOL allocImageUndo(CLayerItem *p,const TILEIMGINFO &info);

    CLayerItem *getBottomNormalLayer();
    CLayerItem *getBottomVisibleImg();
    CLayerItem *getTopPixLayer(int x,int y);
    void calcViewItemCnt();
    int getNormalLayerCnt();

    int getLayerItemNo(CLayerItem *pItem);
    CLayerItem *getLayerItemFromNo(int no);
    void getLayerItemNo_parent(CLayerItem *pItem,int *pdst);
    void getLayerItemFromNo_parent(CLayerItem **ppDst,int parentno,int no);

    void flagOffAll(DWORD dwMask);
    CTileImage *getPaintRefImg();
    CTileImage *getLayerMaskImg(CLayerItem *pCurrent);
    CLayerItem *setLinkMove(int type,BOOL bDisableLink,CLayerItem *pItem);
    CLayerItem *setLinkCheck();
    int getLinkCnt(CLayerItem *pTop);
    void getLinkVisibleImgRect(CLayerItem *pTop,FLAGRECT *pDst);
    BOOL isExistCheckImg();
    CLayerItem *setLinkCombineSome(int type,CLayerItem *pCurrent);
    void resizeCanvas(int movx,int movy);

    CLayerItem *addLayer_APLD(CLayerItem *pIns,const AXString &filename,CProgressDlg *pdlg);
};

#endif
