/*$
Copyright (C) 2013-2016 Azel.

This file is part of AzPainter.

AzPainter is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

AzPainter is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.
$*/

#ifndef _AZPT_IMAGERGB16_H_
#define _AZPT_IMAGERGB16_H_

#include "AXDef.h"
#include "AXRect.h"
#include "struct.h"

class AXImage;
class AXString;
class AXMem;
class CProgressDlg;

class CImageRGB16
{
protected:
    RGBFIX15    *m_pbuf;
    int         m_nWidth,
                m_nHeight;

protected:
    int _getPalette8bit(AXMem *pmem);
    void _toPaletteCol(LPDWORD pPalBuf,int pcnt);

public:
    CImageRGB16();
    ~CImageRGB16();

    RGBFIX15 *getBuf() const { return m_pbuf; }
    RGBFIX15 *getBufPt(int x,int y) const { return m_pbuf + y * m_nWidth + x; }
    int getWidth() const { return m_nWidth; }
    int getHeight() const { return m_nHeight; }

    void free();
    BOOL create(int w,int h);

    void clear(const RGBFIX15 &col);
    void clear(const AXRectSize &rcs,const RGBFIX15 &col);
    void fillCheck(const AXRectSize &rcs,const RGBFIX15 *pCol);
    void getBufTile(RGBAFIX15 *pDst,int x,int y) const;
    void toRGB8bit();

    void drawCanvasNormal(AXImage *pimgDst,const DRAWCANVASINFO &info);
    void drawCanvasScaleDown(AXImage *pimgDst,const DRAWCANVASINFO &info);
    void drawCanvasRotNormal(AXImage *pimgDst,const DRAWCANVASINFO &info);
    void drawCanvasRotHiQuality(AXImage *pimgDst,const DRAWCANVASINFO &info);

    int saveBMP(const AXString &filename,int dpi,CProgressDlg *pdlg);
    int savePNG(const AXString &filename,int nLevel,int colTP,int dpi,CProgressDlg *pProgDlg);
    int saveJPEG(const AXString &filename,int nQuality,int nSamp,int dpi,CProgressDlg *pProgDlg);
    int saveGIF(const AXString &filename,int colTP,CProgressDlg *pdlg);
};

#endif
